BEM.DOM.decl('b-time-targeting-worktime', {

    onSetMod: {

        js: function() {
            this._triggerChangeDebounce = $.debounce(this._triggerChange, 10);

            this._selectsCache = {};
        }

    },

    /**
     * Изменился контрол days-from
     * @param {Object} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onDaysFromChange: function(e, data) {
        BEM.DOM.update(this.elem('days-to'), BEMHTML.apply({
            block: 'b-time-targeting-worktime',
            elem: 'select',
            elemMods: { type: 'days-to' },
            value: +this._getSelect('days-to').val(),
            minValue: data.index + 1,
            options: u['b-time-targeting-worktime'].DAYS_TO_NAMES
        }));

        this._clearCache('days-to');

        this._triggerChangeDebounce();

        return this;
    },

    /**
     * Изменился контрол hours-from
     * @param {Object} e
     * @param {Object} data
     * @returns {BEM}
     * @private
     */
    _onHoursFromChange: function(e, data) {
        BEM.DOM.update(this.elem('hours-to'), BEMHTML.apply({
            block: 'b-time-targeting-worktime',
            elem: 'select',
            elemMods: { type: 'hours-to' },
            type: 'time',
            value: +this._getSelect('hours-to').val(),
            //+1 - потому что нужно значение на час больше чем в hoursFrom
            minValue: data.index + 1,
            options: u['b-time-targeting-worktime'].HOURS_TO_NAMES
        }));

        this._clearCache('hours-to');

        this._triggerChangeDebounce();

        return this;
    },

    /**
     * Уведомляет об изменениях
     * @returns {BEM.DOM}
     * @private
     */
    _triggerChange: function() {
        this.trigger('change', {
            value: this._getValue()
        });

        return this;
    },

    /**
     * Возвращает текущее значение блока
     * @returns {{dayFrom: number, dayTo: number, hourFrom: number, hourTo: number}}
     * @private
     */
    _getValue: function() {
        return u['b-time-targeting'].parseToCode({
            dayFrom: +this._getSelect('days-from').val(),
            dayTo: +this._getSelect('days-to').val(),
            hourFrom: +this._getSelect('hours-from').val(),
            hourTo: +this._getSelect('hours-to').val()
        });
    },

    /**
     * Сбрасывает из кеша блок селекта
     * @param {String} type
     * @private
     */
    _clearCache: function(type) {
        this._selectsCache[type] = null;
    },

    /**
     * Получает и кэширует селект определенного типа.
     *
     * @param {String} type Тип селекта(модификатор: type).
     * @returns {BEM}
     * @private
     */
    _getSelect: function(type) {
        return this._selectsCache[type] ||
            (this._selectsCache[type] = this.findBlockOn(this.findElem('select', 'type', type), 'select'));
    },

    /**
     * Обработчик изменения селекта
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSelectChange: function(e, data) {
        var block = e.block,
            domElem = block.domElem,
            selectType = this.findElem('select').is(domElem) && this.getMod(domElem, 'type');

        if (selectType) {
            if (selectType === 'days-from') {
                this._onDaysFromChange(e, data);
            } else if (selectType === 'days-to') {
                this._triggerChangeDebounce(e, data);
            } else if (selectType === 'hours-from') {
                this._onHoursFromChange(e, data);
            } else if (selectType === 'hours-to') {
                this._triggerChangeDebounce(e, data);
            }
        }
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'select', function(e, data) {
            this._onSelectChange(e, data);
        });
    }
});
