/**
 * Псевдоссылка переключающаяся при клике в инпут (для страницы оплаты рекламной кампании)
 */

(function($) {
/*jshint -W015*/
    BEM.DOM.decl('b-toggle-input', {
        onSetMod: {
            js: function() {
                u.graspSelf.call(this, {
                    input: 'input on input',
                    link: 'link on link'
                });

                this.link.on('click', this.onLinkClick, this);
                this.input
                    .on('focus blur', this.onInputFocusChange, this)
                    .on('change', this.onInputChange, this);
            },

            mode: function(modName, modVal) {
                if (modVal == 'input') {
                    this.input.val(this.link.elem('inner').text());
                } else {
                    this.link.elem('inner').text(this.input.val());
                }
            }
        },

    /**
     * Изменился фокус на инпуте
     * @param {Object} e
     * @returns {BEM}
     */
        onInputFocusChange: function(e) {
            var eventName = e.type;

            this.setMod('focused', eventName == 'focus' ? 'yes' : '');

            this.afterCurrentEvent(function() {
                this.trigger(eventName);
            });

            return this;
        },

    /**
     * Изменилось значение инпута
     * @returns {BEM}
     */
        onInputChange: function() {
            this.afterCurrentEvent(function() {
                this.trigger('change');
            });

            return this;
        },

    /**
     * Если передано value, устанавливает его в качестве значения контрола, если не передано - возвращает текущее значение
     * @param {String} [value] - значение для контрола
     * @returns {*}
     */
        val: function(value) {
            if (value === undefined) {
                return this.input.val();
            } else {
                this.input.val(value);
                this.link.elem('inner').text(value);
            }
        },

    /**
     * Обработчик клика по псевдоссылке
     * @returns {BEM}
     */
        onLinkClick: function() {
            this.toggle(true, this);

            return this;
        },

    /**
     * Переключает контрол в состояние инпут/псевдоссылка и обратно
     * @param {Boolean} isInput - нужно переключить контрол в состояние 'инпут'
     * @param {Object} source - объект, по команде которого произошло переключение
     * @returns {BEM}
     */
        toggle: function(isInput, source) {
            typeof isInput === 'boolean' || (isInput = true);

            this.toggleMod('mode', 'input', 'link', isInput);

            this.afterCurrentEvent(function() {
                this.input.setMod('focused', isInput ? 'yes' : '');
                this.trigger('toggle', { source: source, mode: isInput ? 'input' : 'link' });
            });

            return this;
        }

    }, {

        live: function() {
            this
                .liveInitOnBlockInsideEvent('click', 'link', function() {
                    this.onLinkClick();
                })
                .liveInitOnBlockInsideEvent('focus', 'input');
        }

    });

})(jQuery);
