BEM.DOM.decl({

    block: 'b-toggle',
    elem: 'link'

}, {

    /**
     * Реакция на событие клика по ссылке
     * @param {Event} e объект события
     * @private
     */
    _onClick: function(e) {

        this.getParent().trigger('change', { switcher: this });

        this.params.altContent && this._changeContent(e.block.elem('inner'));

    },

    /**
     * Заменяет текст ссылки на указанный в js-параметре altContent
     * В этот параметр сохраняется текущий текст ссылки
     * @param {jQuery} domElem DOM-нода, контент которой следует заменить
     * @private
     */
    _changeContent: function(domElem) {

        var params = this.params,
            content = domElem.text();

        domElem.text(params.altContent);
        params.altContent = content;

    }

}, {
    live: function() {

        this.liveInitOnBlockEvent('click', 'link', function() {
            this._onClick.apply(this, arguments);
        });

    }
});
