BEM.DOM.decl({

    block: 'b-toggle',
    elem: 'toggle',
    modName: 'animation'

}, {

    _method: function(type) {

        return { show: 'show', hide: 'hide' }[type];

    },

    onElemSetMod: {

        item: {

            state: {

                show: function(item) {

                    this._animate(item, this._method('show'), 'visible');

                },

                hide: function(item) {

                    this._animate(item, this._method('hide'), 'hidden');

                }

            }

        }

    },

    _animate: function(item, method, state) {

        item[method](
            this.params.duration,
            this._onComplete.bind(this, item, state));

    },

    _onComplete: function(item, state) {

        this.setMod(item.removeAttr('style'), 'state', state);

    },

    _show: function(item) {

        this.setMod(item, 'state', this.domElem.is(':visible') ? 'show' : 'visible');

    },

    _hide: function(item) {

        this.setMod(item, 'state', this.domElem.is(':visible') ? 'hide' : 'hidden');

    }

});
