BEM.DOM.decl({

    block: 'b-toggle',
    elem: 'toggle'

}, {

    _onChange: function(e, data) {

        var name = data.switcher.params.name,
            _name = this.params.name;

        if (name && _name && name != _name) return;

        this._update(data);

    },

    _update: function(data) {

        var item = this.domElem.children();

        (item.length == 1) ?
            this._toggle(item, data.index) :
            this._switch(item, data.index);

    },

    _toggle: function(item, index) {

        var show = (typeof index !== 'undefined') ?
                this.params.index == index :
                this.hasMod(item, 'state', 'hidden');

        show ? this._show(item) : this._hide(item);

    },

    _switch: function(item, index) {

        var toHide = item.filter(
                this.buildSelector('item', 'state', 'visible')),

            toShow = typeof index === 'undefined' ?
                toHide.next() :
                item.eq(index);

        this._hide(toHide);
        this._show(toShow.length ? toShow : item.eq(0));

    },

    _hide: function(item) {

        this.setMod(item, 'state', 'hidden');

    },

    _show: function(item) {

        this.setMod(item, 'state', 'visible');

    }

}, {
    live: function() {

        this.liveInitOnParentEvent('change', function() {
            this._onChange.apply(this, arguments);
        });

    }
});
