BEM.DOM.decl({ block: 'b-turbo-landings-selector', elem: 'turbolanding-card' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            this._btn = this.findBlockInside('turbolanding-card-btn', 'button2');

            this._modeMetrikaMap = {
                wizard: 'fast',
                template: 'templates',
                library: 'library'
            };

            this._subMan.wrap(this._btn).on('click', function(event) {
                this._openCanvasWindow(event);

                var turbolandingMode = this._modeMetrikaMap[this.params.mode],
                    metrikaParams = { turbolandingConstructor: {} };
                metrikaParams.turbolandingConstructor[turbolandingMode] = {
                    open: true
                };

                BEM.blocks['b-metrika2'].params({
                    params: metrikaParams
                });
            }, this);
        }
    },

    setParent: function(parent) {
        this._parent = parent;
    },

    _openCanvasWindow: function(event) {
        if (this.params.mode === 'wizard') {
            this._parent.openCanvasWindow(event, this.params.clientId, this.params.value, {
                creationMode: this.params.mode,
            });
        } else if (this.params.mode === 'template') {
            this._parent.openCanvasWindow(event, this.params.clientId, this.params.value, {
                creationMode: this.params.mode
            });
        } else {
            this._parent.openCanvasWindow(null, this.params.clientId, this.params.value, {});
        }
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    },
});
