block('b-turbo-landings-selector').elem('turbolanding-template')(

    elemMod('template', 'short')(function() {
        return applyNext({
            imageName: 'shablon_short.png',
            title: iget2('b-turbo-landings-selector', 'template-short', 'Шаблон: Короткий'),
            templateId: 'short'
        });
    }),

    elemMod('template', 'commodity')(function() {
        return applyNext({
            imageName: 'shablon_tovar.png',
            title: iget2('b-turbo-landings-selector', 'template-commodity', 'Шаблон: Товарный'),
            templateId: 'commodity'
        });
    }),

    elemMod('template', 'empty')(function() {
        return applyNext({
            imageName: 'shablon_empty.png',
            title: iget2('b-turbo-landings-selector', 'template-empty', 'Шаблон: Пустой'),
            templateId: 'empty'
        });
    }),

    js()(function() {
        return {
            templateId: this.templateId,
            value: this.ctx.value,
            clientId: this.ctx.clientId
        }
    }),

    content()(function() {
        return {
            block: 'button2',
            mix: [
                {
                    block: 'b-turbo-landings-selector',
                    elem: 'turbolanding-template-btn'
                }
            ],
            mods: {
                theme: 'clear'
            },
            content: [
                {
                    block: 'b-turbo-landings-selector',
                    elem: 'turbolanding-template-image-wrap',
                    attrs: {
                        'data-btn-name': iget2('b-turbo-landings-selector', 'template-btn-name', 'Выбрать')
                    },
                    content: {
                        block: 'image',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'turbolanding-template-image' }
                        ],
                        url: '/data3/desktop.blocks/b-turbo-landings-selector/__turbolanding-template/' + this.imageName,
                        width: 100,
                        height: 140
                    }
                },
                {
                    block: 'b-turbo-landings-selector',
                    elem: 'turbolanding-template-title',
                    content: this.title
                }
            ]
        };
    }),

    elemMod('no-template', 'yes')(
        mix()(({ block: 'b-turbo-landings-selector', elem: 'turbolanding-template-image' })),

        content()(function() {
            return {
                block: 'button2',
                mods: {
                    theme: 'clear'
                },
                mix: [
                    { block: 'b-turbo-landings-selector', elem: 'turbolanding-template-btn' }
                ],
                content: {
                    elem: 'inner',
                    content: [{
                        elem: 'name',
                        tag: 'span',
                        content: iget2('b-turbo-landings-selector', 'your-template-library', 'Ваша библиотека лендингов')
                    }, {
                        block: 'icon',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'add-turbo-icon', elemMods: { type: 'add' } }
                        ],
                        mods: {
                            type: 'add'
                        }
                    }, {
                        block: 'icon',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'add-turbo-icon', elemMods: { type: 'turbo' } }
                        ],
                        mods: {
                            type: 'turbo'
                        }
                    }]
                }
            };
        })
    )
);
