BEM.DOM.decl({ block: 'b-turbo-landings-selector', elem: 'turbolanding-template' }, {
    /* eslint-disable require-iget2*/
    ruTemplates: {
        short: 'short-preset/ru',
        commodity: 'commodity-preset/ru',
        empty: 'empty-preset/ru'
    },
    /* eslint-enable require-iget2*/
    enTemplates: {
        short: 'short-preset/en',
        commodity: 'commodity-preset/en',
        empty: 'empty-preset/en'
    },

    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            this._btn = this.findBlockInside('turbolanding-template-btn', 'button2');

            this._subMan.wrap(this._btn).on('click', this._openCanvasWindow, this);
        }
    },

    setParent: function(parent) {
        this._parent = parent;
    },

    _openCanvasWindow: function(event) {
        if (this.params.templateId) {
            this._parent.openCanvasWindow(event, this.params.clientId, this.params.value, {
                templateName: this._getTemplateName()
            });
        } else {
            this._parent.openCanvasWindow(null, this.params.clientId, this.params.value, {});
        }
    },

    _getTemplateName: function() {
        var lang = u.consts('lang'),
            templateId = this.params.templateId;

        if (/(ru|ua)/.test(lang)) {
            return this.ruTemplates[templateId];
        }
        return this.enTemplates[templateId];
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    },
});
