block('b-turbo-landings-selector').mod('geoproduct', 'yes')(
    content()(function() {
        return {
            elem: 'selector',
            value: this.ctx.value
        }
    }),

    elem('geoproduct-header').content()(function() {
        var name = this.ctx.name;

        return [
            name ? name : iget2('b-turbo-landings-selector', 'geoproduct-header', 'Страница с дополнительной информацией'),
            // раскомментировать, когда будет готов хелп для баннера Яндекс.Метро (DIRECT-97469)
            // {
            //     block: 'b-help-link',
            //     mods: { type: 'modal' },
            //     stretched: true,
            //     url: u.getHelpUrl('turbo-landing-page')
            // }
        ]
    }),

    elem('selector').content()(function() {
        var val = this.ctx.value || {},
            isEmpty = !+val.id,
            buttonText = isEmpty ?
                iget2('b-turbo-landings-selector', 'select-button-add2', 'Добавить') :
                iget2('b-turbo-landings-selector', 'select-button-change', 'Изменить');

        return [
            {
                elem: 'geoproduct-header',
                name: val.name
            },
            {
                elem: 'disclaimer',
                content: iget2('b-turbo-landings-selector', 'geoproduct-disclaimer', 'Страница откроется по нажатию на креатив.')
            },
            {
                elem: 'turbolanding-link',
                tag: 'span',
                content: [
                    {
                        elem: 'turbolanding-href',
                        url: isEmpty ? '' : val.href
                    },
                    {
                        block: 'button2',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'copy-href-btn' }
                        ],
                        mods: {
                            size: 's',
                            theme: 'clear'
                        },
                        icon: {
                            mods: {
                                type: 'copy'
                            }
                        }
                    },
                    {
                        block: 'popup2',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'copied-to-clipboard-notice' }
                        ],
                        mods: {
                            target: 'anchor',
                            theme: 'normal',
                            view: 'default',
                            tone: 'dark',
                            autoclosable: 'yes'
                        },
                        directions: ['top-center', 'bottom-center'],
                        content: iget2('b-turbo-landings-selector', 'copied-to-clipboard-notice', 'Ссылка скопирована')
                    }
                ]
            },
            {
                elem: 'controls',
                content: [
                    {
                        elem: 'button-delete',
                        btnTheme: 'normal',
                        btnSize: 's',
                        iconTheme: 'dark'
                    },
                    {
                        elem: 'button-select',
                        text: buttonText
                    }
                ]
            }

        ]
    })
);
