BEM.DOM.decl({ block: 'b-turbo-landings-selector', modName: 'geoproduct', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._copyHrefBtn = this.findBlockOn('copy-href-btn', 'button2');
            this._copiedToClipboardNotice = this.findBlockOn('copied-to-clipboard-notice', 'popup2');
            this._copiedToClipboardNotice.setAnchor(this._copyHrefBtn);

            this._subMan.on(this._copyHrefBtn, 'click', this._copyHrefToClipboard, this);
        }
    },

    _copyHrefToClipboard: function() {
        u['b-turbo-landings-selector'].copyHrefToClipboard(this._value.href, this._copiedToClipboardNotice);
    },

    _onButtonSelectClick: function() {
        this.openCanvasWindow(null, this._clientId, this._value, {
            enableTemplates: ['cpm-geoproduct-preset', 'cpm-geoproduct-pro-preset']
        });
    },

    setValue: function(value) {
        this.__base.apply(this, arguments);

        BEM.DOM.replace(this.findElem('geoproduct-header'), BEMHTML.apply({
            block: 'b-turbo-landings-selector',
            elem: 'geoproduct-header',
            mods: { geoproduct: 'yes' },
            name: value && value.name
        }));

        BEM.DOM.replace(this.findElem('turbolanding-href'), BEMHTML.apply({
            block: 'b-turbo-landings-selector',
            elem: 'turbolanding-href',
            mods: { geoproduct: 'yes' },
            url: value && value.href || ''
        }));
    }
});
