block('b-turbo-landings-selector').mod('pretty', 'yes')(
    content()(function() {
        return [
            {
                elem: 'loader'
            },
            {
                elem: 'selector',
                value: this.ctx.value
            },
            {
                elem: 'warning'
            }
        ]
    }),

    elem('loader').content()(function() {
        return { block: 'spin2', mods: { size: 'xxs', progress: 'yes' } };
    }),

    elem('warning').content()(function() {
        return {
            block: 'icon-text',
            mods: {
                theme: 'info',
                size: 'xs'
            },
            text: this.mods['vcard-allowed'] === 'yes' ?
                iget2('b-turbo-landings-selector', 'set-main-url-or-vcard-error3', 'Укажите ссылку на сайт или заполните Виртуальную визитку') :
                iget2('b-turbo-landings-selector', 'set-main-url-error4', 'Укажите ссылку на сайт')

        };
    }),

    elem('turbolanding-link').tag()('span'),

    elem('turbolanding-template-title').tag()('p'),

    elem('selector').content()(function() {
        var val = this.ctx.value || {},
            isEmpty = !+val.id,
            hasSite = this.mods['has-site'] === 'yes',
            buttonText = isEmpty ?
                iget2('b-turbo-landings-selector', 'select-button-add2', 'Добавить') :
                iget2('b-turbo-landings-selector', 'select-button-change', 'Изменить');

        return [
            {
                elem: 'header',
                name: val.name,
                hasSite: hasSite
            },
            {
                elem: 'disclaimer',
                content: u['b-turbo-landings-selector'].getDisclaimer(false, hasSite)
            },
            {
                elem: 'turbolanding-link',
                content: [
                    {
                        elem: 'turbolanding-href',
                        url: isEmpty ? '' : val.href
                    },
                    {
                        block: 'button2',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'copy-href-btn' }
                        ],
                        mods: {
                            size: 's',
                            theme: 'clear'
                        },
                        icon: {
                            mods: {
                                type: 'copy'
                            }
                        }
                    },
                    {
                        block: 'popup2',
                        mix: [
                            { block: 'b-turbo-landings-selector', elem: 'copied-to-clipboard-notice' }
                        ],
                        mods: {
                            target: 'anchor',
                            theme: 'normal',
                            view: 'default',
                            tone: 'dark',
                            autoclosable: 'yes'
                        },
                        directions: ['top-center', 'bottom-center'],
                        content: iget2('b-turbo-landings-selector', 'copied-to-clipboard-notice', 'Ссылка скопирована')
                    }
                ]
            },
            {
                elem: 'controls',
                content: [
                    {
                        elem: 'button-delete',
                        btnTheme: 'normal',
                        btnSize: 's',
                        iconTheme: 'dark'
                    },
                    {
                        elem: 'button-select',
                        text: buttonText
                    }
                ]
            }

        ]
    })
);
