BEM.DOM.decl({ block: 'b-turbo-landings-selector', modName: 'pretty', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._copyHrefBtn = this.findBlockOn('copy-href-btn', 'button2');
            this._copiedToClipboardNotice = this.findBlockOn('copied-to-clipboard-notice', 'popup2');

            this._copiedToClipboardNotice.setAnchor(this._copyHrefBtn);

            this._subMan.on(this._copyHrefBtn, 'click', this._copyHrefToClipboard, this);
        },

        'vcard-allowed': {
            yes: function() {
                this._iconText.setText(iget2('b-turbo-landings-selector', 'set-main-url-or-vcard-error4', 'Укажите ссылку на сайт или заполните Виртуальную визитку'));
            },

            '': function() {
                this._iconText.setText(iget2('b-turbo-landings-selector', 'set-main-url-error4', 'Укажите ссылку на сайт'));
            }
        },

        warning: {
            yes: function() {
                this.setMod('show-more', '');
            }
        }
    },

    _copyHrefToClipboard: function() {
        u['b-turbo-landings-selector'].copyHrefToClipboard(this._value.href, this._copiedToClipboardNotice);
    },

    _getButtonText: function(isEmpty) {
        return isEmpty ?
            iget2('b-turbo-landings-selector', 'select-button-add2', 'Добавить') :
            iget2('b-turbo-landings-selector', 'select-button-change', 'Изменить');
    },

    render: function(turbo, options) {
        var opts = options || {},
            value = turbo || {},
            smooth = opts.smooth,
            hasSite = opts.hasSite,
            time = opts.time,
            isEmpty = !+value.id,
            turboName = value.name,
            effectFn;

        this._value = value;

        effectFn = function() {
            BEM.DOM.replace(this.findElem('header'), BEMHTML.apply({
                block: 'b-turbo-landings-selector',
                elem: 'header',
                name: turboName || u['b-turbo-landings-selector'].getHeader(time, hasSite)
            }));

            if (isEmpty) {
                BEM.DOM.replace(this.findElem('disclaimer'), BEMHTML.apply({
                    block: 'b-turbo-landings-selector',
                    elem: 'disclaimer',
                    content: u['b-turbo-landings-selector'].getDisclaimer(time, hasSite)
                }));
            } else {
                BEM.DOM.replace(this.findElem('turbolanding-href'), BEMHTML.apply({
                    block: 'b-turbo-landings-selector',
                    elem: 'turbolanding-href',
                    url: value && value.href || ''
                }));
            }
            if (smooth) {
                this.setModTtl(this.findElem('header'), 'animate', 'in', 250);
                if (isEmpty) {
                    this.setModTtl(this.findElem('disclaimer'), 'animate', 'in', 250);
                } else {
                    this.setModTtl(this.findElem('turbolanding-href'), 'animate', 'in', 250);
                }
            }
            this.setMod('empty', isEmpty ? 'yes' : '');
        }.bind(this);

        if (smooth) {
            this.setModTtl(this.findElem('header'), 'animate', 'out', 250);
            if (isEmpty) {
                this.setModTtl(this.findElem('disclaimer'), 'animate', 'out', 250);
            } else {
                this.setModTtl(this.findElem('turbolanding-href'), 'animate', 'out', 250);
            }
            window.setTimeout(function() {
                effectFn();
            }, 250);
        } else {
            effectFn();
        }
    },

    setValue: function(value, opts) {
        this.__base.apply(this, arguments);

        // откытываем изменения модификатора, сделанное в родительском методе
        this.toggleMod('empty', 'yes', '');
        this.setMod('show-more', '');
    },

    setModTtl: function(elem, mod, val, ttl) {
        this.setMod(elem, mod, val);
        window.setTimeout(function() {
            this.delMod(elem, mod);
        }.bind(this), ttl);
    }
});
