block('b-turbo-landings-selector')(

    def()(function() {
        var value = this.ctx.value || {};

        !+value.id && (this.mods.empty = 'yes');

        return applyNext();
    }),

    js()(function() {
        return {
            clientId: this.ctx.clientId,
            value: this.ctx.value,
            isCpmGeoproduct: this.ctx.isCpmGeoproduct // nullable
        };
    }),

    content()(function() {
        return {
            elem: 'selector',
            value: this.ctx.value
        }
    }),

    elem('button-select').replace()(function() {
        return {
            block: 'button',
            mix: [
                { block: this.block, elem: 'button-select' }
            ],
            mods: { disabled: this.mods.disabled },
            content: this.ctx.text
        };
    }),

    elem('button-delete').replace()(function() {
        var ctx = this.ctx,
            btnSize = ctx.btnSize,
            btnTheme = ctx.btnTheme,
            iconTheme = ctx.iconTheme;

        return {
            block: 'button',
            mix: [
                { block: this.block, elem: 'button-delete' }
            ],
            mods: {
                size: btnSize || 'xs',
                theme: btnTheme || 'icon',
                'only-icon': 'yes',
                disabled: this.mods.disabled
            },
            attrs: {
                title: iget2('b-turbo-landings-selector', 'button-delete', 'Удалить')
            },
            content: {
                block: 'icon',
                mods: { 'size-16': 'delete', theme: iconTheme || 'light' },
                mix: { block: 'button', elem: 'icon' }
            }
        };
    }),

    elem('selector').content()(function() {
        var val = this.ctx.value || {},
            isEmpty = !+val.id,
            buttonText = isEmpty ?
                iget2('b-turbo-landings-selector', 'select-button-add', 'Выбрать') :
                iget2('b-turbo-landings-selector', 'select-button-change', 'Изменить'),
            labelText = isEmpty ? iget2('b-turbo-landings-selector', 'empty-label', 'Турбо-страница не выбрана') : val.name;

        return [
            {
                elem: 'button-select',
                text: buttonText
            },
            {
                elem: 'label',
                content: labelText
            },
            {
                elem: 'button-delete'
            }
        ];
    })
);
