BEM.DOM.decl('b-turbo-landings-selector', {

    onSetMod: {
        js: function() {
            this._value = this.params.value || {};
            this._clientId = this.params.clientId;
            this._isCpmGeoproduct = this.params.isCpmGeoproduct;

            this._elemLabel = this.elem('label');

            this._subMan = BEM.create('i-subscription-manager');
            this._buttonSelect = this.findBlockOn('button-select', 'button');
            this._buttonClear = this.findBlockOn('button-delete', 'button');
            this._iconText = this.findBlockInside('warning', 'icon-text');

            this._subMan.wrap(this._buttonSelect).on('click', this._onButtonSelectClick, this);
            this._subMan.wrap(this._buttonClear).on('click', this._clearLanding, this);
        },

        disabled: function(modeName, modVal) {
            this._buttonSelect.setMod('disabled', modVal);
            this._buttonClear.setMod('disabled', modVal);
        }
    },

    /**
     * Отрывает попап с кнопками
     * @private
     */
    _onButtonSelectClick: function() {
        if (this._isCpmGeoproduct) {
            this._openCpmGeoproductCanvas();
            return;
        }

        var _this = this,
            popupSelector = u.consts('isLandingsWizardAllowed') ?
                'b-turbo-landings-selector__turbolanding-card' : 'b-turbo-landings-selector__turbolanding-template',
            popupElem = u.consts('isLandingsWizardAllowed') ?
                'cards-popup' : 'templates-popup',
            popup = BEM.blocks['b-shared-popup'].getInstance({
                animate: 'yes',
                'has-close': 'yes',
                autoclosable: 'yes'
            }, { directions: ['top-left-right', 'bottom-left-right'] }),
            popupContent = BEMHTML.apply({
                block: 'b-turbo-landings-selector',
                elem: popupElem,
                clientId: this._clientId,
                value: this._value
            });

        popup.setContent(popupContent, function() {
            this
                .findBlocksInside(popupSelector)
                .forEach(function(turbolandingCard) {
                    turbolandingCard.setParent(_this);
                });
        });

        if (this._value && +this._value.id) {
            this.openCanvasWindow(null, this._clientId, this._value, {});
        } else {
            popup.show(this._buttonSelect);
        }

        this._popup = popup;
    },

    _openCpmGeoproductCanvas: function() {
        this.openCanvasWindow(null, this._clientId, this._value, {
            enableTemplates: ['cpm-geoproduct-preset', 'cpm-geoproduct-pro-preset']
        });
    },

    _onSelectLanding: function(e, landing) {
        this.setValue(landing);

        // генерируем событие только если меняем значение через UI
        this.trigger('change', landing);

        if (this._popup) {
            this._popup.hide();
        }
    },

    /**
     * Очищает выбранную турбо-страницу
     * @private
     */
    _clearLanding: function() {
        this.setValue();

        // генерируем событие только если меняем значение через UI
        this.trigger('change', {});
    },

    /**
     * Возвращает выбранный элемент
     * @return {Object}
     */
    getValue: function() {
        return this._value || {};
    },

    /**
     * Возвращает текст на кнопке в зависимости от того, выбрана сейчас турбостраница или нет
     * @param {Boolean} isEmpty - true если турбо не выбрана
     * @return {String}
     */
    _getButtonText: function(isEmpty) {
        return isEmpty ?
            iget2('b-turbo-landings-selector', 'select-button-add', 'Выбрать') :
            iget2('b-turbo-landings-selector', 'select-button-change', 'Изменить');
    },

    /**
     * Устанавливает значение
     * @param {Object} [value] - новый лендинг
     */
    setValue: function(value) {
        var val = value || {},
            isEmpty = !+val.id,
            buttonText = this._getButtonText(isEmpty),
            labelText = isEmpty ? iget2('b-turbo-landings-selector', 'empty-label', 'Турбо-страница не выбрана') : val.name;

        this._value = val;
        this._buttonSelect.setText(buttonText);
        this._elemLabel.text(labelText);
        this.setMod('empty', isEmpty ? 'yes' : '');
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    },

    openCanvasWindow: function(event, clientId, value, additionalParams) {
        var mods = {
                type: 'turbo-landings',
                width: additionalParams.creationMode === 'wizard' ? 'short' : 'wide'
            },
            hasSite = this.hasMod('has-site', 'yes'),
            uploader;

        uploader = BEM.DOM.blocks['b-banner-storage-frame'].create(mods);

        uploader.on('select', this._onSelectLanding, this);

        uploader.on('close', function() {
            uploader.destruct();
        });

        uploader.show(clientId, value.id, hasSite, additionalParams);
    }
});
