(function() {

    u.register({
        'b-turbo-landings-selector': {
            getTurboRecommendation: function(login, cid, model) {
                var dna = window.dna;

                if (
                    !dna ||
                    !dna.utils ||
                    !dna.utils.getQueryExecutor ||
                    !login
                ) {
                    return;
                }

                var queryExecutor = dna.utils.getQueryExecutor(login),
                    bids = model.getBanners().filter(function(elem) {
                        return !elem.get('isNewBanner')
                    }).map(function(elem) {
                        return +elem.id
                    });

                if (bids.length === 0) {
                    return;
                }

                model.getBanners().forEach(function(bannerModel) {
                    bannerModel.set('turboRecommendationIsFetching', true);
                });

                queryExecutor.getTurboRecommendation(login, cid, bids)
                    .then(function(response) {
                        var bannersRecommendations = getTurboHashMap(response);

                        model.getBanners().forEach(function(bannerModel) {
                            var bid = bannerModel.get('bid'),
                                bannerRecommendations = bannersRecommendations[bid];

                            if (bannerRecommendations) {
                                bannerModel.get('turboRecommendation').update({
                                    hasRecommendation: true,
                                    pageLoadedTimingAvg: bannerRecommendations.pageLoadedTimingAvg,
                                    url: bannerRecommendations.url
                                });
                            }

                            bannerModel.set('turboRecommendationIsFetching', false);
                        })
                    })
                    .catch(function() {
                        model.getBanners().forEach(function(bannerModel) {
                            bannerModel.set('turboRecommendationIsFetching', false);
                        })
                    });
            },

            getDisclaimer: function(hasRecommendation, hasSite) {
                return hasRecommendation ?
                    iget2('b-turbo-landings-selector', 'disclaimer-has-recommendation', 'Это дольше, чем 70% страниц в Директе. Турбо-страницы ускоряют загрузку и увеличивают конверсию.') :
                    hasSite ?
                        iget2('b-turbo-landings-selector', 'mobile-turbo-disclaimer', 'Если ваш сайт не адаптирован под мобильные устройства, создайте мобильную Турбо-страницу, она поможет снизить отказы и увеличить конверсию') :
                        iget2('b-turbo-landings-selector', 'desktop-turbo-disclaimer', 'Создавайте Турбо-страницы, если у вас нет своего сайта, а также в дополнение к основному сайту для отдельных товаров и сезонных акций');
            },

            getHeader: function(recommendationTime, hasSite) {
                var recommendationHeader = recommendationTime && u.pluralForms(
                        iget2(
                            'b-turbo-landings-selector', 'header-has-recommendation',
                            'Страница перехода загружается {time} {секунду|секунды|секунд}',
                            { time: recommendationTime }
                        ),
                        recommendationTime
                    ),
                    noRecommendationHeader = hasSite ?
                        iget2('b-turbo-landings-selector', 'mobile-header', 'Снижение отказов на мобильном до 30%') :
                        iget2('b-turbo-landings-selector', 'desktop-header', 'Cтраница перехода с ускоренной загрузкой');

                return recommendationTime ?
                    recommendationHeader :
                    noRecommendationHeader;
            },

            copyHrefToClipboard: function(text, clipboardElement) {
                var textArea = document.createElement('textarea');
                textArea.value = text;
                document.body.appendChild(textArea);
                textArea.select();

                try {
                    document.execCommand('copy');
                } catch (err) {}

                document.body.removeChild(textArea);

                showCopiedToClipboardNotice(clipboardElement);
            },
        }
    });

    /**
     * Строит объект вида ключ(id баннера) - boolean значение (есть или нет турбо рекомендации для баннера)
     * @param {Object[]} bannersRecommendations - массив рекомендаций для баннеров.
     *
     * @returns {{bannerId: Boolean}}
     */
    function getTurboHashMap(bannersRecommendations) {
        var turboHashMap = Object.create(null);

        bannersRecommendations.forEach(function(bannerRecommendation) {
            var recommendations = bannerRecommendation.recommendations,
                // массив рекомендаций для баннера в каждом элементе содержит одинаковый bid, поэтому берем из 1 элемента.
                bid = u._.get(recommendations, '[0].keys[0].bid'),
                recommendationTurbo = recommendations && recommendations.find(function(elem) {
                    return elem.keys[0].type === 'addTurboWebSiteToBanner'; // тип рекоммендаций по турбо
                });

            if (recommendationTurbo) {
                var pageLoadedTimingAvg = Math.ceil(recommendationTurbo.kpi.pageLoadedTimingAvg / 1000);
                turboHashMap[bid] = {
                    type: recommendationTurbo.keys[0].type,
                    pageLoadedTimingAvg: pageLoadedTimingAvg,
                    url: recommendationTurbo.keys[0].userKey1
                }
            }
        });

        return turboHashMap;
    }

    function showCopiedToClipboardNotice(clipboardElement) {
        var timeoutMs = 2000;

        clipboardElement.setMod('visible', 'yes');

        setTimeout(function() {
            clipboardElement.setMod('visible', 'no');
        }, timeoutMs);
    }
})();
