BEM.DOM.decl({ block: 'b-user-settings-add-email' }, {

    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                form: 'i-form on form',
                formElem: 'form',
                accept: 'button on accept',
                decline: 'button on decline'
            });

            this.accept.on('click', this.onAccept, this);
            this.decline.on('click', this.onDecline, this);

            this.request = BEM.create('i-request_type_ajax', {
                url: this.formElem.attr('action'),
                type: this.formElem.attr('method'),
                dataType: 'json',
                cache: false
            });
        }
    },

    onAccept: function() {
        var _this = this;

        this.setMod(this.elem('error'), 'hidden', 'yes');

        this.request.get(this.form.serialize(), function(data) {
            if (data.errors && data.errors.invalid_email === 1) {
                var elem = _this.elem('error');

                elem.text(iget2('b-user-settings-add-email', 'e-mail-vveden-nekorrektno', 'E-mail введен некорректно'));
                _this.delMod(elem, 'hidden');
            } else {
                window.location.reload();
            }
        })
    },

    onDecline: function() {
        this.setMod(this.elem('error'), 'hidden', 'yes');
        this.trigger('decline');
    }
});
