(function() {
    BEM.DOM.decl({ name: 'b-user-settings', baseBlock: 'i-glue' }, {
        onSetMod: {
            js: function() {
                this.__base();

                u.graspSelf.call(this, {
                    addEmail: 'b-user-settings-add-email inside',
                    addEmailDropdown: 'dropdown on email-add-new-dropdown'
                });

                this.showEmailPopup = this.findBlockOn('email-show-all-popup', 'popup');

                this.addEmailDropdown._popup._moveToContainer();

                var showEmailsRequest = BEM.create('i-request_type_ajax', {
                        url: this.params.showAllEmailsUrl,
                        dataType: 'json'
                    }),
                    model = this.model,
                    _this = this;

                this.showEmailPopup && this.showEmailPopup.onFirst('show', function(e) {
                    showEmailsRequest.get({}, function(data) {
                        e.block
                            .hide()
                            .setContent(BEMHTML.apply($.extend(data, {
                                block: 'b-show-user-emails'
                            })))
                            .show()
                    });
                });

                this.findBlockOn('i-form').on('submit', function() {
                    _this.hideError('main');

                    var validationResult = model.validate(),
                        modelValidationErrors = validationResult.errors,
                        isModelValidationPassed = validationResult.valid,
                        isVerifiedPhoneCheckPassed = !_this.verifiedPhoneRequired || _this.getVerifiedPhoneId();

                    if (isModelValidationPassed && isVerifiedPhoneCheckPassed) {
                        var selectedRadioButton = _this.findBlockOn('homepage', 'radio-button');

                        if (selectedRadioButton) {
                            var homePageValue = selectedRadioButton.val() || 'overview';

                            BEM.blocks['i-web-api-request'].feature.setState([
                                {
                                    feature: 'homepage_use_grid',
                                    enabled: homePageValue === 'campaigns'
                                }
                            ], u.consts('ulogin')).catch(function() {
                                _this.displayError('main', iget2('b-user-settings', 'chto-to-ne-tak', 'Что-то пошло не так'));
                            }).then(function(e) {
                                if (e.success) {
                                    this.submit();
                                } else {
                                    _this.displayError('main', iget2('b-user-settings', 'chto-to-ne-tak', 'Что-то пошло не так'));
                                }
                            }.bind(this));
                        } else {
                            this.submit();
                        }
                    } else {
                        if (!isModelValidationPassed && modelValidationErrors) {
                            _this.displayError(
                                'main',
                                Object.values(validationResult.errorsData).map(function(errorField) {
                                    return errorField[0].text;
                                }).join('<br/>')
                            );
                        }

                        if (!isVerifiedPhoneCheckPassed) {
                            _this._store.dispatch({
                                type: '@phoneConfirm/SET_PHONE_ERROR',
                                phoneError: !_this.getPhone() ?
                                    iget2('b-user-settings', 'vvedite-telefon', 'Введите телефон') :
                                    iget2('b-user-settings', 'podtverdite-telefon', 'Подтвердите телефон')
                            });
                        }
                    }

                    return false;
                });

                this.addEmail.on('decline', function() {
                    this.addEmailDropdown.hide();
                    this.addEmail.findBlockInside('new-email', 'input').val('')
                }, this);

                this.addEmailDropdown.on('hide', function() {
                    this.addEmail.onDecline();
                }, this)
            }
        },

        destruct: function() {
            if (this._unsubscribeStore) {
                this._unsubscribeStore();
            }

            this.__base.apply(this, arguments);
        },

        setVerifiedPhoneRequired: function(verifiedPhoneRequired) {
            this.verifiedPhoneRequired = verifiedPhoneRequired;
        },

        getPhone: function() {
            if (!this._store) {
                return;
            }

            return this._store.getState().phoneConfirm.phone;
        },

        isPhoneConfirmed: function() {
            if (!this._store) {
                return false;
            }

            return this._store.getState().phoneConfirm.isPhoneConfirmed;
        },

        getVerifiedPhoneId: function() {
            if (!this._store) {
                return '';
            }

            if (this.getPhone() && this.isPhoneConfirmed()) {
                return this._store.getState().phoneConfirm.phoneId;
            }

            return '';
        },

        setStore: function(store) {
            this._store = store;
            this._unsubscribeStore = store.subscribe(function() {
                this.findBlockOn('verified-phone-id', 'b-hidden').val(this.getVerifiedPhoneId() || '')
            }.bind(this));
        },

        hideError: function(errorId) {
            this.setMod(this.elem('error', 'id', errorId), 'hidden', 'yes');
        },

        displayError: function(errorId, message) {
            var elem = this.elem('error', 'id', errorId);

            elem.html(message);
            this.delMod(elem, 'hidden');
        }

    });
}());
