BEM.DOM.decl({ block: 'b-userbar-dna' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this.bindToWin('scroll', this.fixPosition.bind(this));

            this._renderDna(dna);

            this._addResizeWatcher();
        }
    },

    _addResizeWatcher: function() {
        var warningsBlock = this.findBlockOutside('b-page').findBlockInside('b-page__warnings');

        if (warningsBlock) {
            var watcher = BEM.blocks['resize-watcher'].getInstance({
                owner: warningsBlock.domElem,
                ignoreWidth: true,
                timeout: 50
            });

            watcher.on('change', function() {
                this.fixPosition();
            }, this);
        }
    },

    fixPosition: function() {
        var topStyle,
            top = this.domElem.get(0).getBoundingClientRect().top;

        if (top <= 0) {
            topStyle = 0;
        } else {
            topStyle = top;
        }

        this.elem('content').css({
            top: topStyle + 'px'
        });
    },

    _renderDna: function(dna) {
        var dnaComp = this._getDnaComponent(dna),
            domElem = this.elem('content').get(0);

        BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
            dna.reactDOMRender(dnaComp, domElem);
        }.bind(this));
    },

    _getDnaComponent: function(dna) {
        return dna.reactCreateElement(dna.components.UserBarWrapper, {}, null);
    }
});
