block('b-validation-errors')(
    js()(function() {
        return {
            inputErrors: this.ctx.controllerInputWarnErrors,
            outputErrors: this.ctx.controllerOutputWarnErrors,
            ctx: this.ctx
        }
    }),

    content()(function() {
        return {
            elem: 'wrap',
            content: [
                {
                    elem: 'head-panel',
                    content: [
                        {
                            block: 'icon-text',
                            mods: { theme: 'alert', size: 'ms' },
                            text: iget2('b-validation-errors', 'obnaruzheny-oshibki-validacii', 'Обнаружены ошибки валидации')
                        }, {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [
                                {
                                    block: 'b-validation-errors',
                                    elem: 'expander'
                                }
                            ],
                            content: this.mods.expanded == 'yes' ? iget2('b-validation-errors', 'skryt', 'Скрыть') : iget2('b-validation-errors', 'pokazat', 'Показать')
                        }, {
                            block: 'link',
                            mods: {
                                pseudo: 'yes'
                            },
                            mix: [
                                {
                                    block: 'b-validation-errors',
                                    elem: 'close'
                                }
                            ],
                            content: iget2('b-validation-errors', 'zakryt', 'Закрыть')
                        }
                    ]
                }, {
                    elem: 'errors-wrap',
                    content: [
                        this.ctx.controllerInputWarnErrors && this.ctx.controllerInputWarnErrors.length != 0 ||
                        this.ctx.controllerOutputWarnErrors && this.ctx.controllerOutputWarnErrors.length != 0 && {
                            elem: 'validation-error',
                            content: [
                                {
                                    elem: 'title',
                                    tag: 'h3',
                                    content: iget2('b-validation-errors', 'oshibki-validacii-dannyh-json', 'Ошибки валидации данных json-схем')
                                },
                                {
                                    elem: 'jss-validation-warn',
                                    content: [
                                        this.ctx.controllerInputWarnErrors &&
                                            this.ctx.controllerInputWarnErrors.length != 0 && {
                                                elem: 'schema-errors-block',
                                                title: iget2('b-validation-errors', 'vhodnye-dannye', 'Входные данные'),
                                                errors: this.ctx.controllerInputWarnErrors
                                            },
                                        this.ctx.controllerOutputWarnErrors &&
                                            this.ctx.controllerOutputWarnErrors.length != 0 && {
                                                elem: 'schema-errors-block',
                                                title: iget2('b-validation-errors', 'vyhodnye-dannye', 'Выходные данные'),
                                                errors: this.ctx.controllerOutputWarnErrors
                                            }
                                    ]
                                }
                            ]
                        },
                        {
                            elem: 'validation-error',
                            elemMods: { type: 'ctx' }
                        }
                    ]
                }
            ]
        };
    }),

    elem('title').tag()('h3'),

    elem('error-list').tag()('ul'),

    elem('error').tag()('li'),

    elem('validation-error').elemMod('type', 'request').content()(function() {
        return [
            {
                elem: 'title',
                tag: 'h3',
                content: iget2('b-validation-errors', 'oshibki-validacii-parametrov-ajax', 'Ошибки валидации параметров ajax-запросов')
            },
            {
                elem: 'content',
                elemMods: {
                    type: this.elemMods.type
                }
            }
        ];
    }),

    elem('validation-error').elemMod('type', 'ctx').content()(function() {
        return [
            {
                elem: 'title',
                tag: 'h3',
                content: iget2('b-validation-errors', 'oshibki-validacii-konteksta-blokov', 'Ошибки валидации контекста блоков')
            },
            {
                elem: 'content',
                elemMods: {
                    type: this.elemMods.type
                }
            }
        ];
    }),

    elem('validation-error').elemMod('type', 'response').content()(function() {
        return [
            {
                elem: 'title',
                tag: 'h3',
                content: iget2('b-validation-errors', 'oshibki-validacii-rezultatov-ajax', 'Ошибки валидации результатов ajax-запроса')
            },
            {
                elem: 'content',
                elemMods: {
                    type: this.elemMods.type
                }
            }
        ];
    }),

    elem('errors-block').content()(function() {
        return [
            {
                elem: 'pages-errors-title',
                tag: 'h4',
                content: this.ctx.title
            },
            {
                elem: 'errors-list',
                content: this.ctx.errors.map(function(error) {

                    return {
                        elem: 'error',
                        content: [
                            {
                                tag: 'strong',
                                content: error.schemaPath
                            },
                            '&nbsp;–&nbsp;',
                            error.message
                        ]
                    };
                })
            }
        ];
    }),

    elem('schema-errors-block').content()(function() {
        return [
            {
                elem: 'pages-errors-title',
                tag: 'h4',
                content: this.ctx.title
            },
            {
                elem: 'schema-errors-list',
                mix: {
                    block: 'b-validation-errors',
                    elem: 'errors-list'
                },
                errors: this.ctx.errors
            }
        ];
    }),

    elem('schema-errors-list').content()(function() {
        var res = [];

        u._.forEach(this.ctx.errors, function(error, key) {
            res.push({
                elem: 'error',
                content: [
                    {
                        tag: 'strong',
                        content: key
                    },
                    '&nbsp;–&nbsp;',
                    error.message,
                    ' (keyword:&nbsp',
                    error.keyword,
                    ')'
                ]
            });
        });

        return res;
    })
);
