BEM.DOM.decl('b-validation-errors', {

    onSetMod: {

        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                expander: 'link on expander',
                close: 'link on close',
                errors: 'errors-wrap'
            });

            this.expander.on('click', function(e) {
                this.toggleMod('expanded', 'yes', '');
                BEM.DOM.update(e.block.elem('inner'), this.getMod('expanded') === 'yes' ? iget2('b-validation-errors', 'skryt', 'Скрыть') : iget2('b-validation-errors', 'pokazat', 'Показать'));
            }, this);

            this.close.on('click', function() {
                //плашка нам еще нужна для валидации аякс-запросов
                this.delMod('visible');
            }, this);

            this._addReferences();

            BEM.blocks['b-ctx-validator'].on('error', function(e, data) {
                this._addError({ type: 'ctx', title: data.block, errors: [data.error] });
            }, this);

            var params = this.params;

            params.inputErrors && !$.isEmptyObject(params.inputErrors) &&
                // eslint-disable-next-line no-console
                console.error('json schema input errors', params.inputErrors);

            params.outputErrors && !$.isEmptyObject(params.outputErrors) &&
                // eslint-disable-next-line no-console
                console.error('json schema output errors', params.outputErrors);
        }
    },

    _addReferences: function() {
        var refs = window.CLIENT_SCHEMA_REFS || {};

        Object.keys(refs).forEach(function(key) {
            u.tv4.addSchema(key, refs[key]);
        });
    },

    /**
     * Возвращает схему для валидации по названию контроллера
     * @param {'request'|'response'} type тип схемы
     * @param {String} cmd имя контроллера
     * @returns {Object}
     * @private
     */
    _getSchema: function(type, cmd) {
        return window.CLIENT_SCHEMAS && window.CLIENT_SCHEMAS[type + '-' + cmd];
    },

    /**
    * Добавляет в плашку сообщение об ошибке в аякс-запросе
    * @param {Object} data
    * @param {String} data.cmd контроллер в котором произошла ошибка
    * @param {Array} data.errors массив с ошибками
    * @returns {BEM}
    * @private
    */
    _addError: function(data) {
        this
            .setMod('expanded', 'yes')
            .setMod('visible', 'yes');

        BEM.DOM.append(this.elem('content', 'type', data.type), BEMHTML.apply({
            block: 'b-validation-errors',
            elem: 'errors-block',
            title: data.title,
            errors: data.errors
        }));

        return this;
    }
}, {

});
