block('b-vcard-banners').elem('actions')(

    js()(function() {
        return {
            bid: this.ctx.banner.bid
        };
    }),

    content()(function() {
        return {
            block: 'b-banner-actions',
            content: [
                {
                    event: 'toggle-phrases',
                    caption: iget2('b-vcard-banners', 'klyuchevye-frazy-na-gruppu', 'Ключевые фразы на группу')
                },
                {
                    event: 'edit-vcard',
                    hidden: !this.ctx.vcard,
                    caption: [
                        iget2('b-vcard-banners', 'virtualnaya-vizitka', 'Виртуальная визитка'),
                        {
                            block: 'b-vcard-number',
                            mix: [{
                                block: 'b-vcard-banners',
                                elem: 'vcard-number'
                            }],
                            vcard: this.ctx.vcard
                        },
                        '&rarr;'
                    ]
                },
                {
                    event: 'create-vcard',
                    hidden: !!this.ctx.vcard,
                    caption: [iget2('b-vcard-banners', 'sozdat-vizitku', 'Создать визитку'), '&nbsp&rarr;']
                },
                {
                    event: 'unlink-vcard',
                    hidden: !this.ctx.vcard || !this.ctx.banner.href,
                    caption: iget2('b-vcard-banners', 'udalit-vizitku-iz-obyavleniya', 'Удалить визитку из объявления')
                }
            ].map(function(item) {
                var mods = {
                    event: item.event
                };

                item.hidden && (mods.hidden = 'yes');

                return {
                    elem: 'item',
                    mix: [{
                        block: 'b-vcard-banners',
                        elem: 'action-item',
                        elemMods: mods
                    }],
                    content: {
                        block: 'link',
                        mods: { pseudo: 'yes' },
                        js: { event: item.event },
                        mix: [
                            {
                                block: 'b-banner-actions-link'
                            },
                            {
                                block: 'b-vcard-banners',
                                elem: 'actions-link',
                                elemMods: { event: item.event }
                            }
                        ],
                        content: item.caption
                    }
                };
            }, this)
        };
    })
);
