BEM.DOM.decl({ block: 'b-vcard-banners', elem: 'actions' }, {

    onSetMod: {
        js: function() {
            BEM.MODEL
                .getOne({ name: 'm-banner', id: this.params.bid })
                // элементу интересно только это событие, так как надо перерисовывать номер визитки,
                // тут надо переназначать блоку номера визитки модель визитки,
                // блок номера сам уже разберется что и как перерисовать
                .on('vcard', 'change', function(e, data) {
                    var value = data.value,
                        vcardModel = value ? BEM.MODEL.getOne({ name: 'm-vcard', id: value.vcard_id }) : null,
                        hasVCard = !!vcardModel;

                    // назначаем модель визитки для блока номера визитки
                    this
                        .findBlockOn('vcard-number', 'b-vcard-number')
                        .setModel(vcardModel);

                    // обновление состояний кнопок
                    // набор показываемых кнопок при наличии и отсутствии визитки разный
                    this
                        .toggleMod(this.elem('action-item', 'event', 'create-vcard'), 'hidden', 'yes', hasVCard)
                        .toggleMod(this.elem('action-item', 'event', 'edit-vcard'), 'hidden', 'yes', !hasVCard)
                        .toggleMod(this.elem('action-item', 'event', 'unlink-vcard'), 'hidden', 'yes', !hasVCard);
                }, this);
        },

        disabled: function(modName, modVal) {
            // вкл/выкл кнопок действий при блокировании всего блока
            ['create-vcard', 'edit-vcard', 'unlink-vcard']
                .forEach(function(eventName) {
                    var actionLink = this.findBlockOn(this.elem('actions-link', 'event', eventName), 'link');

                    actionLink.setMod(modName, modVal);
                }, this);
        }
    }

}, {

    live: function() {
        // включаем действия только если требуется
        this.liveInitOnBlockInsideEvent('init', 'link', function(e) {
            var actionLink = e.target;

            if (!actionLink.params.event) return;

            actionLink.on('click', function() {
                var bid = this.params.bid,
                    parent = this.getParent(),
                    event = actionLink.params.event;

                if (event === 'toggle-phrases') {
                    parent.togglePhrasesPopup(actionLink.domElem, bid);
                }

                event = ({
                    'unlink-vcard': 'request-unlink-vcard',
                    'create-vcard': 'request-edit-vcard',
                    'edit-vcard': 'request-edit-vcard'
                })[event];

                // события действий передаются от элемента в блок
                event &&
                    parent.trigger(event, bid);
            }, this);
        });

        // блок должен быть проинициализирован для реакцию на модель баннера
        return false;
    }

});
