block('b-vcard-banners').elem('item').content()(function() {
    var banner = this.ctx.banner;

    return [
        banner.adgroup_id ?
            {
                elem: 'group-number',
                content: '№ ' + banner.adgroup_id
            } :
            '',
        {
            elem: 'header',
            content: {
                block: 'checkbox',
                mix: [{
                    block: 'b-checkboxes-group',
                    elem: 'item',
                    elemMods: { bid: banner.bid }
                }],
                checkboxAttrs: {
                    autocomplete: 'off',
                    value: banner.bid
                },
                text: {
                    elem: 'label',
                    elemMods: { selectable: 'yes' },
                    mix: [{
                        block: 'b-vcard-banners',
                        elem: 'label'
                    }],
                    content: [
                        '&#8470; M-',
                        banner.bid,
                        !!banner.group_name && [' ', '(' + iget2('b-vcard-banners', 'gruppa-s', 'Группа: "{foo}"', {
                            foo: u.hellipCut(banner.group_name, 15, '&hellip;', u.escapeHTML)
                        }) + ')'],
                        banner.isArchived ? [' ', iget2('b-vcard-banners', 'v-arhive', '(в архиве)')] : ''
                    ]
                }
            }
        },
        {
            elem: 'preview',
            content: {
                block: 'b-banner-preview',
                hideSitelinks: true,
                banner: banner,
                geoNames: banner.geo_name,
                hideBid: true,
                geoIds: banner.geo_ids,
                showGeo: true,
                randPhrase: u['dm-base-group'].getRandomActivePhrase(banner.phrases),
                statusOpenStat: banner.statusOpenStat === 'Yes',
                statusClickTrack: banner.status_click_track
            }
        },
        {
            block: 'b-vcard-banners',
            elem: 'actions',
            elemMods: { bid: banner.bid },
            banner: banner,
            vcard: this.ctx.vcard
        }
    ];

});
