block('b-vcard-banners')(

    js()(true),

    content()(function() {
        var camp = this.ctx.campaign;

        return [
            {
                elem: 'workspace',
                mix: [{
                    block: 'b-checkboxes-group',
                    mods: { ignored: 'yes' },
                    js: true
                }],
                content: [
                    {
                        elem: 'head',
                        content: [
                            {
                                elem: 'filtration',
                                content: [
                                    {
                                        block: 'checkbox',
                                        mix: [{
                                            block: 'b-checkboxes-group',
                                            elem: 'item'
                                        }],
                                        checkboxAttrs: { autocomplete: 'off' },
                                        text: iget2('b-vcard-banners', 'obyavleniya', 'Объявления')
                                    },
                                    {
                                        block: 'b-dropdown-filter',
                                        mix: [{
                                            block: 'b-vcard-banners',
                                            elem: 'filter'
                                        }],
                                        js: {
                                            modelName: 'm-filter-vcards-banners',
                                            modelData: {
                                                value: camp.banners_with_phone_cnt < camp.banners_cnt ?
                                                    'without' :
                                                    'with',
                                                archived: false
                                            }
                                        },
                                        popup: {
                                            js: { directions: 'bottom-left' },
                                            mods: {
                                                adaptive: 'no',
                                                animate: 'no'
                                            }
                                        },
                                        items: [
                                            {
                                                value: 'all',
                                                text: iget2('b-vcard-banners', 'vse', 'все')
                                            },
                                            {
                                                value: 'without',
                                                text: iget2('b-vcard-banners', 'bez-vizitok', 'без визиток')
                                            },
                                            {
                                                value: 'with',
                                                text: iget2('b-vcard-banners', 's-vizitkami', 'с визитками')
                                            }
                                        ],
                                        footer: {
                                            block: 'checkbox',
                                            mods: { toggle: 'archived' },
                                            checkboxAttrs: { autocomplete: 'off' },
                                            text: iget2('b-vcard-banners', 'pokazyvat-arhivnye-obyavleniya', 'Показывать архивные объявления')
                                        }
                                    }
                                ]
                            },
                            {
                                block: 'link',
                                mix: [{
                                    block: 'b-vcard-banners',
                                    elem: 'reset-vcard-filtration',
                                    elemMods: { hidden: 'yes' }
                                }],
                                mods: { pseudo: 'yes' },
                                content: iget2('b-vcard-banners', 'vernutsya-k-polnomu-spisku', 'Вернуться к полному списку объявлений')
                            }
                        ]
                    },
                    {
                        elem: 'content',
                        mix: this.ctx.mixes && this.ctx.mixes.content,
                        content: [
                            {
                                elem: 'items',
                                content: (function(banners, vcards) {
                                    return banners
                                        .sort(function(banner1, banner2) {
                                            // выталкиваем в конец списка в приоритетном порядке:
                                            return (banner1.isArchived - banner2.isArchived) || // - архивные баннеры
                                                (banner1.bid - banner2.bid); // - баннеры, имеющие больший идентификатор
                                        })
                                        .map(function(banner) {
                                            return {
                                                block: 'b-vcard-banners',
                                                elem: 'item',
                                                elemMods: {
                                                    bid: banner.bid,
                                                    hidden: 'yes',
                                                    active: 'yes'
                                                },
                                                banner: banner,
                                                vcard: banner.vcard && vcards[banner.vcard.vcard_id]
                                            };
                                        });
                                })(this.ctx.banners, this.ctx.vcards.reduce(function(vcards, vcard) {
                                    vcards[vcard.vcard_id] = vcard;

                                    return vcards;
                                }, {}))
                            },
                            {
                                elem: 'error-message'
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
