BEM.DOM.decl('b-vcard-banners', {

    onSetMod: {
        js: function() {
            this._checkboxGroup = this.findBlockOn('workspace', 'b-checkboxes-group');

            this._ignoredMap = {};

            this._filter = this.findBlockOn('filter', 'b-dropdown-filter');

            this._initEvents();

            this.refresh();
        }
    },

    onElemSetMod: {
        item: {
            active: function(elem, modName, modVal) {
                var index = this.elem('item').index(elem);

                // добавляем или исключаем чекбокс группы из игнорирования
                if (!modVal) {
                    this._ignoredMap[index] = true;
                } else if (this._ignoredMap[index]) {
                    delete this._ignoredMap[index];
                }

                if (modVal) {
                    // при выставлении active_yes сносим прозрачность
                    elem.css({ opacity: '' });

                    // более не _hidden
                    this.delMod(elem, 'hidden');
                }
            },

            disabled: function(elem, modName, modVal) {
                // при блокировании блока нужно блокировать действия над баннером
                this.setMod(this.elem('actions', 'bid', this.getMod(elem, 'bid')), modName, modVal);
            },

            hidden: {
                yes: function(elem) {
                    // более не _active
                    this.delMod(elem, 'active');
                },

                animate: function(elem) {
                    var _this = this;

                    // анимированное схлопывание элемента с последующим выставлением _hidden_yes
                    elem.animate({ opacity: 0 }, function() {
                        _this.setMod(elem, 'hidden', 'yes');

                        // если до удалялись, что не один не _active_yes, то
                        _this.afterCurrentEvent(function() {
                            !_this.elem('item', 'active', 'yes').length ?
                                // обновляем содержимое
                                _this.refresh() :
                                // или обновляем игнорирования чекбоксов
                                _this._updateIgnoredCheckboxes();
                        });
                    });
                }
            }
        }
    },

    /**
     * Показывает/скрывает попап с ключевыми фразами
     * @param {jQuery} [switcher] jQuery узел switcher
     * @param {String} [bid]
     * @private
     */
    togglePhrasesPopup: function(switcher, bid) {
        // для принудительного скрытия попапа
        if (!arguments.length) {
            this._phrasesPopup && this._phrasesPopup.hide();

            return;
        }

        if (!this._phrasesPopup) {
            this._phrasesPopup = BEM.blocks['b-shared-popup'].getInstance(
                { animate: 'yes', 'has-close': 'yes' },
                { directions: ['bottom-left-right', 'top-left-right', 'right-middle-middle'] });
        }

        this._phrasesPopup
            .setContent(BEMHTML.apply({
                block: 'b-vcard-banners',
                elem: 'phrases-popup',
                content: (BEM.MODEL.getOne({ name: 'm-banner', id: bid }).get('splited_phrases') || []).join(', ')
            }))
            .toggle(switcher);
    },

    /**
     * Блокирует или снимает блокировку с блока баннера в зависимости от переданного параметра
     * @param {BEM.MODEL} bannerModel
     * @param {Boolean} state блокировать или нет
     */
    toggleDisabled: function(bannerModel, state) {
        this.toggleMod(this._getItemElem(bannerModel.get('bid')), 'disabled', 'yes', state);
    },

    /**
     * Блокирует или снимает блокировку с блока действий баннера в зависимости от переданного параметра
     * @param {BEM.MODEL} bannerModel
     * @param {Boolean} state блокировать или нет
     * @returns {BEM}
     */
    toggleActions: function(bannerModel, state) {
        this.toggleMod(this.elem('actions', 'bid', bannerModel.get('bid')), 'disabled', 'yes', state);
    },

    /**
     * Отфильтровать баннеры по принадлежности к указанной визитке
     * @param {String} vcardId
     */
    showVCardBanners: function(vcardId) {
        this.getFilterModel().set('vcard_id', vcardId);
    },

    /**
     * Возвращает модель фильтра
     * @returns {BEM.MODEL}
     */
    getFilterModel: function() {
        return this._filter.model;
    },

    /**
     * Возвращает список идентификаторов выбранных баннеров
     * @returns {String[]}
     * @private
     */
    getCheckedBids: function() {
        return this._checkboxGroup.getChecked().map(function(checkbox) {
            return checkbox.val();
        });
    },

    /**
     * Обновляет список баннеров:
     *  - прячет все баннеры
     *  - фильтрует модели
     *  - показывает отфильтрованные баннеры
     *
     * Если передан список моделей баннеров, то
     *  - каждая модель будет проверена на право быть показанной
     *  - если встретится модель, которая не должна показываться, она анимировано исчезнет
     *
     * Если список баннеров будет пуст, то в зависимости от фильтра
     * будет показано сообщение о причинах пустого списка.
     * @param {BEM.MODEL[]} [bannerModels] список моделей баннеров
     */
    refresh: function(bannerModels) {
        var errorMessage,
            filterModel,
            animationRunning = !!(bannerModels || []).filter(function(model) {
                var elem = this._getItemElem(model.get('bid')),
                    animation = !this._isViewAllowed(model) && !!elem.length;

                animation && this.setMod(elem, 'hidden', 'animate');

                return animation;
            }, this).length;

        // выходим, если идёт процесс анимированное скрытие
        if (animationRunning) return;

        // фильтруем
        bannerModels = BEM.MODEL.get('m-banner')
            .filter(function(model) {
                var elem = this._getItemElem(model.get('bid'));

                this
                    // прячем независимо от того, разрешено показывать или нет
                    .setMod(elem, 'hidden', 'yes')
                    // форсировано сносим модификатор _active (для случая, когда элемент уже _hidden_yes)
                    .delMod(elem, 'active');

                return this._isViewAllowed(model);
            }, this);

        if (bannerModels.length) {
            // затем возвращаем блоки в список и если они были ранее отмечены то выставляем checked для checkbox
            bannerModels.forEach(function(model) {
                var elem = this._getItemElem(model.get('bid'));

                // включаем то, что разрешено показывать
                this.setMod(elem, 'active', 'yes');
            }, this);
        } else {
            // если нечего показать, показываем ошибку исходя из параметров фильтрации
            filterModel = this.getFilterModel();

            filterModel.get('vcard_id') && filterModel.set('vcard_id', '');

            errorMessage = ({
                with: iget2('b-vcard-banners', 'v-etoy-kampanii-net', 'В этой кампании нет объявлений с визитками'),
                without: iget2('b-vcard-banners', 'v-etoy-kampanii-net-100', 'В этой кампании нет объявлений без визиток'),
                all: filterModel.get('archived') ?
                    iget2('b-vcard-banners', 'v-etoy-kampanii-net-101', 'В этой кампании нет объявлений') :
                    iget2(
                        'b-vcard-banners',
                        'v-etoy-kampanii-otsutstvuyut',
                        'В этой кампании отсутствуют баннеры, для которых доступно использование визитки'
                    )
            })[filterModel.get('value')];
        }

        this.elem('error-message').text(errorMessage || '');

        this._updateIgnoredCheckboxes();
    },

    /**
     * Дозволено ли модели отображаться или нет
     * @param {BEM.MODEL} bannerModel модель баннера
     * @returns {Boolean}
     * @private
     */
    _isViewAllowed: function(bannerModel) {
        var filterModel = this.getFilterModel(),
            vcardId = filterModel.get('vcard_id'),
            vcard = bannerModel.get('vcard'),
            filterValue;

        // фильтрация баннеров по конкретной визитке
        if (vcardId) return vcard && vcardId === vcard.vcard_id;

        // отсеивание архивных баннеров, если фильтр не просит архивные
        if (!filterModel.get('archived') && bannerModel.get('isArchived')) return false;

        filterValue = filterModel.get('value');

        if (filterValue === 'all') return true;

        if (filterValue === 'with') return !!vcard;

        if (filterValue === 'without') return !vcard;

        return false;
    },

    /**
     * Обновление карты игнорирования чекбоксов
     * @private
     */
    _updateIgnoredCheckboxes: function() {
        this._checkboxGroup.setIgnored(this._ignoredMap);
    },

    /**
     * Сбрасывает чекбоксы на выбранных баннерах
     */
    unCheckAllSelected: function() {
        this._checkboxGroup.unCheckAll();
    },

    /**
     * Shortcut для получения элемента баннера
     * @param {String} bid идентификатор баннера
     * @returns {jQuery}
     * @private
     */
    _getItemElem: function(bid) {
        return this.elem('item', 'bid', bid);
    },

    /**
     * Инициализация событий блока
     * @private
     */
    _initEvents: function() {
        this._filter
            .findBlockInside({ block: 'checkbox', modName: 'toggle', modVal: 'archived' })
            .on('change', function(e) {
                this.getFilterModel().update({ archived: e.target.isChecked() });
            }, this);

        this.getFilterModel()
            .on('change', function() { this.refresh(); }, this)
            .on('vcard_id', 'change', function(e, data) {
                var useFiltration = !data.value;

                this
                    .toggleMod(this.elem('filtration'), 'hidden', 'yes', !useFiltration)
                    .toggleMod(this.elem('reset-vcard-filtration'), 'hidden', 'yes', useFiltration);
            }, this);

        this.findBlockOn('reset-vcard-filtration', 'link')
            .on('click', function() {
                this.getFilterModel().set('vcard_id', '');
            }, this);

        this._checkboxGroup
            .on('change', function() {
                this.trigger('check', this.getCheckedBids());
            }, this);
    }

}, {

    live: true

});
