block('b-vcard-control').mod('type', 'banner')(
    def()(function() {
        return applyNext({
            hasCopyFromPrev: this.ctx.hasCopyFromPrev,
            modelParams: this.ctx.modelParams,
            is_vcard_open: this.ctx.is_vcard_open,
            errors: this.ctx.errors,
            vcard: this.ctx.vcard || {}
        });
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            hasCopyFromPrev: this.hasCopyFromPrev,
            live: false
        };
    }),

    content()(function() {
        return [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'tumbler-wrapper'
                    },
                    {
                        block: 'b-vcard-control',
                        elem: 'hint',
                        content: this.ctx.vcardHint || iget2('b-vcard-control', 'ukazhite-adres-dlya-pokaza', 'Укажите адрес для показа объявления на Яндекс.Картах')
                    },
                    ' ',
                    {
                        elem: 'link',
                        elemMods: { visibility: this.is_vcard_open ? 'visible' : 'hidden' }
                    }
                ]
            },
            this.errors && {
                block: 'b-vcard-control',
                elem: 'errors'
            },
            {
                block: 'b-toggle',
                elem: 'toggle',
                elemMods: { animation: 'slide' },
                js: { duration: 'fast' },
                content: {
                    elem: 'item',
                    elemMods: { state: this.is_vcard_open && !this.is_vcard_collapsed ? 'visible' : 'hidden' },
                    content: {
                        block: 'b-vcard-control',
                        elem: 'vcard-wrapper',
                        content: !!this.is_vcard_open && {
                            block: 'b-vcard-control',
                            elem: 'vcard-content',
                            modelParams: this.modelParams,
                            hasCopyFromPrev: this.hasCopyFromPrev,
                            vcard: this.vcard
                        }
                    }
                }
            }
        ];
    })
);
