BEM.DOM.decl({ name: 'b-vcard-control', modName: 'type', modVal: 'banner' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._toggle = this.findBlockOn('b-toggle')
                .on('change', function() {
                    this.afterCurrentEvent(function() {
                        this.bannerModel.set(
                            'is_vcard_collapsed',
                            this._toggle.getMod(this._toggle.elem('item'), 'state') !== 'show');
                    });
                }, this);

            if (this._vcard) this._updateModel(true);

            this.bannerModel.on('is_vcard_open', 'change', this._onStateChange, this);
        }
    },

    /**
     * Проверяет на пустоту хэш визитки
     * @param {Object} vcardHash
     * @returns {Boolean}
     */
    isVCardEmpty: function(vcardHash) {
        return Object.keys(vcardHash).every(function(name) {
            return name == 'worktime' || name == 'worktimes' || !vcardHash[name];
        });
    },

    /**
     * Заполняет форму данными
     * @param {Object} data данные визитки
     * @param {Deferred} deferred промис
     */
    fill: function(data, deferred) {
        var vcardData = data.vcard || {};

        if (!data.has_vcard) {
            if (this._vcard && this.bannerModel.get('has_vcard')) {
                this._showWarning(deferred);
            } else {
                this.clear();
                deferred && deferred.resolve();
            }

        } else {
            this._openVCard(function() {
                this._vcard.fill(vcardData);
            });
            deferred && deferred.resolve();
        }
    },

    /**
     * Очищает форму если она уже определена
     */
    clear: function() {
        this._vcard && this._vcard.clear();
    },

    /**
     * инициализирует модели баннера и группы
     * @private
     */
    _initModel: function() {
        this.__base.apply(this, arguments);

        this.bannerModel = BEM.MODEL.getOrCreate(this.params.modelParams);

        this.groupModel = BEM.MODEL.getOrCreate({
            name: this.params.modelParams.parentName,
            id: this.params.modelParams.parentId
        });

    },

    /**
     * Изменилось поле is_vcard_open, отвечающее за состояние переключателя
     * @private
     */
    _onStateChange: function() {
        if (!this._tumbler.hasMod('focused'))
            this._tumbler.setMod('checked', this.bannerModel.get('is_vcard_open') ? 'yes' : '');
    },

    /**
     * Отрисовка визитки
     * @param {Function} [callback]
     * @returns {BEM}
     * @private
     */
    _openVCard: function(callback) {
        var params = this.params;

        if (this._vcard) {
            return callback && callback.apply(this);
        }

        BEM.DOM.update(this.elem('vcard-wrapper'), BEMHTML.apply({
            block: 'b-vcard-control',
            elem: 'vcard-content',
            modelParams: params.modelParams,
            common: params.common,
            hasCopyFromPrev: params.hasCopyFromPrev
        }), function() {
            this._vcard = this.findBlockInside('b-form-vcard');
            callback && callback.apply(this)
        }, this);

        this._updateModel(true);
    },

    /**
     * Изменилось значение тумблера есть/нет визитки
     * @param {Object} e
     * @param {Object} data
     * @param {Boolean} data.checked
     * @private
     */
    _onTumblerChange: function(e, data) {
        var checked = data.checked;

        if (checked) this._openVCard();

        this.bannerModel.set('is_vcard_open', +checked);

        u.campOptions.set('ci_hidden', +!checked);
    },

    /**
     * Обновляет модель при изменении формы
     * @param {Boolean} initial метод выполняется при инициализации
     * @private
     */
    _updateModel: function(initial) {
        var form = this._vcard ? this._vcard.serialize('object') : {},
            isEmpty = this.isVCardEmpty(form),
            isChecked = this._tumbler.hasMod('checked');

        if (initial) this._initialForm = $.extend({}, form);

        this.setMod('lock', 'yes');
        this.bannerModel
            .set('is_vcard_open', isChecked ? 1 : 0)
            .set('isVCardEmpty', isEmpty)
            .set('vcard', form);

        if (initial) {
            this.bannerModel.fields.vcard.fixData();
        }

        this.afterCurrentEvent(function() {
            this.delMod('lock');
        });

        this.trigger('change', form);

    },

    /**
    * Реакция на событие обновления формы
    * @param {Event} e объект события
    * @param {Object} data данные события
    * @private
    */
    _onVCardUpdate: function(e, data) {
        this._openVCard(this._updateModel);
    }

}, {

});
