BEM.DOM.decl({ name: 'b-vcard-control', modName: 'type', modVal: 'campaign' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._updateModel(true);
        }
    },

    /**
     * Кеширует модель кампании со страницы параметров кампании
     * @private
     */
    _initModel: function() {
        this.model = this.findBlockOutside('b-campaign-settings').model;
    },

    /**
     * Обновляет модель при изменении формы
     * @param {Boolean} initial метод выполняется при инициализации
     * @private
     */
    _updateModel: function(initial) {

        var form = this._vcard.serialize('object'),
            isEmpty = Object.keys(form).every(function(name) {
                return name == 'worktime' || !form[name];
            }),
            isChecked = this._isEnabled();

        this.setMod('lock', 'yes');

        if (initial) this._initialForm = $.extend({}, form);

        this.model
            .set('vcard', form)
            .set('with_ci', isChecked && !isEmpty);

        this.elem('hidden', 'name', 'with-ci').val(isChecked && !isEmpty ? '1' : '0');

        this.afterCurrentEvent(function() {
            this.delMod('lock');
        });

        this.trigger('change', form);
    }

}, {});
