block('b-vcard-control')(

    elem('link').tag()('span'),

    elem('hidden')(

        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name + '',
                value: this.ctx.value + ''
            };
        })
    ),

    def()(function() {
        return applyNext({
            is_vcard_collapsed: this.ctx.is_vcard_collapsed,
            is_vcard_open: this.ctx.is_vcard_open,
            group: this.ctx.group || {},
            errors: this.ctx.errors,
            vcard: this.ctx.vcard || {}
        });
    }),

    js()(function() {
        return { modelParams: this.ctx.modelParams };
    }),

    mix()(function() {
        return {
            block: 'b-toggle',
            js: true
        };
    }),

    content()(function() {
        return [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'tumbler-wrapper'
                    },
                    {
                        block: 'b-vcard-control',
                        elem: 'hint',
                        content: this.ctx.vcardHint || iget2('b-vcard-control', 'ukazhite-adres-dlya-pokaza', 'Укажите адрес для показа объявления на Яндекс.Картах')
                    },
                    ' ',
                    {
                        elem: 'link',
                        elemMods: { visibility: this.is_vcard_open && !this.is_vcard_collapsed ? 'visible' : 'hidden' }
                    },
                    {
                        elem: 'hidden',
                        elemMods: { name: 'with-ci' },
                        name: 'camp_with_common_ci',
                        value: this.is_vcard_open ? '1' : '0'
                    }
                ]
            },
            this.errors && {
                block: this.block,
                elem: 'errors'
            },
            {
                elem: 'body',
                elemMods: { opened: this.is_vcard_open && !this.is_vcard_collapsed ? 'yes' : 'no' }
            }
        ];
    }),

    elem('link').content()(function() {
        return [
            '(',
            {
                block: 'b-toggle',
                elem: 'link',
                js: { altContent: this.is_vcard_open && !this.is_vcard_collapsed ? iget2('b-vcard-control', 'pokazat-102', 'показать') : iget2('b-vcard-control', 'skryt-103', 'скрыть') },
                content: this.is_vcard_open && !this.is_vcard_collapsed ? iget2('b-vcard-control', 'skryt-103', 'скрыть') : iget2('b-vcard-control', 'pokazat-102', 'показать')
            },
            ')'
        ];
    }),

    elem('tumbler-wrapper').content()(function() {
        return {
            block: 'tumbler',
            mods: {
                size: 's',
                checked: this.is_vcard_open ? 'yes' : ''
            },
            mix: [{
                block: 'b-vcard-control',
                elem: 'tumbler',
                js: true
            }],
            leftText: iget2('b-vcard-control', 'da', 'да'),
            rightText: iget2('b-vcard-control', 'net', 'нет')
        };
    }),

    elem('body').content()(function() {
        return {
            block: 'b-toggle',
            elem: 'toggle',
            elemMods: { animation: 'slide' },
            js: { duration: 'fast' },
            content: {
                elem: 'item',
                elemMods: { state: this.is_vcard_open ? 'visible' : 'hidden' },
                content: {
                    block: 'b-vcard-control',
                    elem: 'vcard'
                }
            }
        };
    }),

    elem('errors').content()(function() {
        return {
            block: 'b-toggle',
            content: [
                {
                    block: 'b-message',
                    mods: { type: 'error' },
                    mix: [{
                        block: this.block,
                        elem: 'message'
                    }],
                    content: iget2('b-vcard-control', 'oshibki-v-polyah-formy', 'Ошибки в полях формы &laquo;Адрес и телефон&raquo;')
                },
                {
                    elem: 'toggle',
                    elemMods: { animation: 'slide' },
                    js: { duration: 'fast' },
                    content: {
                        elem: 'item',
                        elemMods: { state: 'hidden' },
                        content: this.errors && this.errors.map(function(error) {
                            return {
                                block: 'b-message',
                                mods: { type: 'error' },
                                content: error
                            };
                        })
                    }
                },
                {
                    elem: 'link',
                    js: { altContent: iget2('b-vcard-control', 'skryt-103', 'скрыть') },
                    content: iget2('b-vcard-control', 'podrobnee', 'подробнее')
                }
            ]
        };
    }),

    elem('vcard').content()(function() {
        return {
            block: 'b-form-vcard',
            hasCopyFromPrev: this.ctx.hasCopyFromPrev,
            vcard: this.vcard,
            mods: { cache: 'yes' },
            js: true
        };
    }),

    // используется только в модификаторе _type_banner
    elem('vcard-content').content()(function() {
        return {
            block: 'b-form-vcard',
            modelParams: this.ctx.modelParams,
            hasCopyFromPrev: this.ctx.hasCopyFromPrev,
            vcard: this.ctx.vcard || {},
            mods: { cache: 'yes' }
        };
    })
);
