BEM.DOM.decl('b-vcard-control', {

    onSetMod: {

        js: function() {
            this._initModel();
            this._vcard = this.findBlockInside('b-form-vcard');
            this._tumbler = this.findBlockOn('tumbler', 'tumbler')
                .on('change', this._onTumblerChange, this);
            this._toggle = this.findBlockInside('b-toggle');
        }

    },

    /**
     * Заполняет форму данными
     */
    fill: function(data) {
         //implemented in subclasses
    },

    /**
     * Очищает форму
     */
    clear: function() {
        this._vcard.clear();
    },

    /**
     * Проверяет, изменилась ли форма с момента инициализации
     * @returns {boolean}
     */
    isFormChanged: function() {

        var form = this._vcard.serialize('object'),
            initialForm = this._initialForm;

        return Object.keys(form).some(function(name) {
            if (['auto_bounds', 'auto_point', 'auto_precision'].indexOf(name) > -1 &&
                !initialForm[name])
                return false;

            return form[name] !== initialForm[name];
        });

    },

    /**
     * Валидация. Вернет true, если визитка валидна
     * @returns {Boolean}
     */
    validate: function() {
        if (this._isEnabled()) {
            var result = this._vcard.setMod('validation', 'on').validate(),
                toggle = this._toggle;

            if (!result && toggle.hasMod(toggle.elem('item'), 'state', 'hidden')) {
                this.findBlockInside('link', 'link').trigger('click');
            }

            return result;
        } else {
            this._vcard.delMod('validation');

            return true;
        }
    },

    /**
     * инициализация модели
     * @private
     */
    _initModel: function() {
        //implemented in subclasses
    },

    /**
     * Обработчик переключения тумблеров
     * @private
     */
    _onTumblerChange: function() {
        //implemented in subclasses
    },

    /**
     * Возвращает флаг, что визитка включены
     * @returns {Boolean}
     * @private
     */
    _isEnabled: function() {
        return this._tumbler.hasMod('checked');
    },

    /**
    * Показывает предупреждающий конфирм
    * @private
    */
    _showWarning: function(deferred) {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-vcard-control',
                'vy-uvereny-chto-hotite',
                'Вы уверены, что хотите скопировать пустую контактную информацию из предыдущего объявления?'
            ),
            onYes: function() {
                this.clear();
                deferred.resolve();
            }
        }, this);
    },

    /**
     * Обновляет исходные данные формы.
     * Требуется для смещения начальных значений
     * формы при ленивой инициализации, например, метро.
     * @param {String[]} fields
     * @private
     */
    _updateInitials: function(fields) {
        var form = this._vcard.serialize('object');

        fields.forEach(function(field) {
            this._initialForm[field] = form[field];
        }, this)
    },

    /**
     * Обновляет модель при изменении формы
     * @param {Boolean} initial метод выполняется при инициализации
     * @private
     */
    _updateModel: function(initial) {
        //implemented in subclasses
    },

    /**
     * Реакция на событие обновления формы
     * @param {Event} e объект события
     * @param {Object} data данные события
     * @private
     */
    _onVCardUpdate: function(e, data) {
        this.trigger('update');
        this._updateModel();
    },

    /**
     * Реакция на событие переключения чекбокса
     * @param {Boolean} isChecked
     * @private
     */
    _onCheckboxChange: function(isChecked) {
        var toggle = this._toggle,
            isVisible = toggle.hasMod(toggle.elem('item'), 'state', 'visible'),
            vcard,
            cityInputs;

        this.toggleMod(this.elem('link'), 'visibility', 'visible', 'hidden', isChecked);
        this.toggleMod(this.elem('body'), 'opened', 'yes', 'no', isChecked);

        if (isChecked ? !isVisible : isVisible) {
            this.findBlockInside('link', 'link').trigger('click');
        }

        if (isChecked) {
            vcard = this.findBlockInside('b-form-vcard');
            cityInputs = u._.filter(vcard.serialize(), function(item) {
                return (item.name == 'city' || item.name == 'city_code') && item.value != '';
            });

            // предполагается, что если заполнен город или код города в телефоне,
            // то не надо фокусироваться на инпут страны - вряд ли его хотят поменять
            // баг про это: https://st.yandex-team.ru/DIRECT-64078
            if (cityInputs.length == 0) {
                setTimeout(function() {
                    vcard.findBlockInside(vcard.findElem('input', 'name', 'country'), 'input').elem('control').focus();
                }, 100);
            }
        }

        this.afterCurrentEvent(function() {
            this._updateModel();
        });
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('metro-init', 'b-form-vcard', function() {
                this._updateInitials(['metro']);
            })
            .liveInitOnBlockInsideEvent('update', 'b-form-vcard', function(e, data) {
                this._onVCardUpdate(e, data);
            });

        return false;
    }

});

BEM.DOM.decl({ block: 'b-vcard-control', elem: 'tumbler' }, {}, {
    live: function() {
        this.liveInitOnBlockEvent('change', 'tumbler', function(e, data) {
            // выполняется в контексте b-vcard-control__tumbler
            this.getParent()._onCheckboxChange(data.checked);
        });
    }
});
