BEM.DOM.decl('b-vcard-number', {

    onSetMod: {
        js: function() {
            var vcardId = this.params.vcardId;

            vcardId && this.setModel(BEM.MODEL.getOne({ name: 'm-vcard', id: vcardId }));
        }
    },

    /**
     * Связывает блок с моделью визитки
     * @param {BEM.MODEL|null} model
     */
    setModel: function(model) {
        // отвязываемся от старой модели визитки
        this._model &&
            this._initModelEvents(false);

        this._model = model;

        // привязываемся к новой модели визитки
        this._model &&
            this._initModelEvents(true);

        this._updatePosition();
        this._updateColor();
    },

    /**
     * При разрушении отцепиться от модели
     */
    destruct: function() {
        this._model && this._initModelEvents(false);

        this.__base.apply(this, arguments);
    },

    /**
     * Привязка или отвязка от событий модели визитки
     * @param {Boolean} isBinding
     * @private
     */
    _initModelEvents: function(isBinding) {
        var method = isBinding ? 'on' : 'un';

        this._model[method]('position', 'change', this._updatePosition, this);
        this._model[method]('color', 'change', this._updateColor, this);
    },

    /**
     * Обновляет цвет блока
     * @private
     */
    _updateColor: function() {
        this.setMod('color', this._model ? this._model.get('color') : '');
    },

    /**
     * Обновляет номер позиции блока согласно сортировке моделей
     * @private
     */
    _updatePosition: function() {
        this.domElem.text(this._model ? this._model.get('position') : '');
    }

});
