block('b-vcard-view').content()(function() {

    var vcard = this.ctx.vcard,
        isEmpty = !Object.keys(vcard).length,
        dayNames = [iget2('b-vcard-view', 'pn', 'пн'), iget2('b-vcard-view', 'vt', 'вт'), iget2('b-vcard-view', 'sr', 'ср'), iget2('b-vcard-view', 'cht', 'чт'), iget2('b-vcard-view', 'pt', 'пт'), iget2('b-vcard-view', 'sb', 'сб'), iget2('b-vcard-view', 'vs', 'вс')],
        formatWorktime = function(worktime) {

            return iget2('b-vcard-view', 'days-s-timefrom-do', '{days} с {timeFrom} до {timeTo}', {
                days: dayNames[worktime.d1] + '-' + dayNames[worktime.d2],
                timeFrom: worktime.h1 + ':' + worktime.m1,
                timeTo: worktime.h2 + ':' + worktime.m2
            });
        };

    return isEmpty ?
        {
            elem: 'field',
            content: iget2('b-vcard-view', 'ne-vybran', 'Не выбран')
        } :
        [
            !!(vcard.country || vcard.city) && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'mestopolozhenie', 'Местоположение') + ': ',
                    !!vcard.country && u.escapeHTML(vcard.country),
                    !!vcard.country && !!vcard.city && ', ',
                    !!vcard.city && u.escapeHTML(vcard.city)
                ]
            },
            !!vcard.phone && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'telefon', 'Телефон') + ': ',
                    u.escapeHTML(vcard.country_code) + ' ',
                    u.escapeHTML(vcard.city_code) + ' ',
                    u.escapeHTML(vcard.phone),
                    !!vcard.ext && [' (', iget2('b-vcard-view', 'dob', 'доб.'), ' ', u.escapeHTML(vcard.ext), ')']
                ]
            },
            !!vcard.name && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'nazvanie-kompanii-fio', 'Название компании (ФИО)') + ': ',
                    u.escapeHTML(vcard.name)
                ]
            },
            !!vcard.worktimes.length && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'vremya-raboty', 'Время работы') + ': ',
                    vcard.worktimes.map(formatWorktime).join(', ')
                ]
            },
            !!vcard.contactperson && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'kontaktnoe-lico', 'Контактное лицо') + ': ',
                    u.escapeHTML(vcard.contactperson)
                ]
            },
            !!vcard.street && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'adres-ul-s-d', 'Адрес: ул. {foo}, д. {bar}', {
                        foo: u.escapeHTML(vcard.street),
                        bar: u.escapeHTML(vcard.house)
                    }),
                    !!vcard.build && iget2('b-vcard-view', 'k-s', ', к. {foo}', {
                        foo: u.escapeHTML(vcard.build)
                    }),
                    !!vcard.apart && iget2('b-vcard-view', 'ofis-s', ', офис {foo}', {
                        foo: u.escapeHTML(vcard.apart)
                    })
                ]
            },
            !!vcard.contact_email && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'el-pochta', 'Эл. почта') + ': ',
                    {
                        block: 'link',
                        url: 'mailto:' + u.escapeHTML(vcard.contact_email),
                        content: u.escapeHTML(vcard.contact_email)
                    }
                ]
            },
            !!vcard.im_client && {
                elem: 'field',
                content: [
                    u.escapeHTML(vcard.im_client).toUpperCase(),
                    ': ',
                    u.escapeHTML(vcard.im_login)
                ]
            },
            !!vcard.extra_message && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'podrobnee-o-tovare-usluge', 'Подробнее о товаре (услуге)') + ': ',
                    u.escapeHTML(vcard.extra_message)
                ]
            },
            !!vcard.org_details && !!vcard.org_details.ogrn && {
                elem: 'field',
                content: [
                    iget2('b-vcard-view', 'ogrn-ogrnip', 'ОГРН/ОГРНИП') + ': ',
                    u.escapeHTML(vcard.org_details.ogrn)
                ]
            }
        ];
});
