BEM.DOM.decl({ block: 'b-vcards', elem: 'actions' }, {}, {

    live: function() {
        // включаем действия только если требуется
        this.liveInitOnBlockInsideEvent('init', 'link', function(e) {
            var actionLink = e.target;

            if (!actionLink.params.event) return;

            actionLink.on('click', function() {
                var vcardId = this.params.vcard_id,
                    parent = this.getParent(),
                    event = actionLink.params.event;

                if (event === 'edit-vcard') {
                    parent.openEditor(vcardId);
                } else if (event === 'show-vcard') {
                    parent.openViewer(vcardId);
                }

                // события действий передаются от элемента в блок
                event = ({
                    'assign-vcard': 'request-assign-vcard',
                    'show-vcard': 'show-vcard'
                })[event];

                event &&
                    parent.trigger(event, vcardId);
            }, this);
        });
    }

});
