block('b-vcards').elem('banners-counts').content()(function() {
    var bannersCount = this.ctx.bannersCount,
        activeCount,
        archiveCount;

    if (bannersCount) {
        activeCount = bannersCount.active;
        archiveCount = bannersCount.total - activeCount;
    }

    return [
        !!activeCount && {
            elem: 'banners-count',
            content: u.pluralizeWord([
                iget2('b-vcards', 'n-1-obyavlenie', '{n} объявление', {
                    n: activeCount,
                    context: 'n - 1'
                }),
                iget2('b-vcards', 'n-2-obyavleniya', '{n} объявления', {
                    n: activeCount,
                    context: 'n - 2'
                }),
                iget2('b-vcards', 'n-5-obyavleniy', '{n} объявлений', {
                    n: activeCount,
                    context: 'n - 5'
                })
            ], activeCount)
        },

        !!(activeCount && archiveCount) && ', ',

        !!archiveCount && {
            elem: 'banners-count',
            content: u.pluralizeWord([
                iget2('b-vcards', 'n-1-arhivnoe-obyavlenie', '{n} архивное объявление', {
                    n: archiveCount,
                    context: 'n - 1'
                }),
                iget2('b-vcards', 'n-2-arhivnyh-obyavleniya', '{n} архивных объявления', {
                    n: archiveCount,
                    context: 'n - 2'
                }),
                iget2('b-vcards', 'n-5-arhivnyh-obyavleniy', '{n} архивных объявлений', {
                    n: archiveCount,
                    context: 'n - 5'
                })
            ], archiveCount)
        }
    ];
});
