block('b-vcards').elem('description').content()(function() {
    var vcard = this.ctx.vcard,

        phone = (function(p, country, city, phone, ext) {
            country && p.push(country);
            city && p.push('(' + city + ')');
            phone && p.push(phone);
            ext && p.push(iget2('b-vcards', 'dob', 'доб.'), ext);

            return p.join(' ');
        })([], vcard.country_code, vcard.city_code, vcard.phone, vcard.ext),

        address = (function(p, country, city, metro, street, house, build, apart) {
            country && p.push(country);
            city && p.push(city);
            metro && p.push(iget2('b-vcards', 'm', 'м.') + ' ' + metro);
            street && p.push(iget2('b-vcards', 'ul', 'ул.') + ' ' + street);
            house && p.push(iget2('b-vcards', 'd', 'д.') + ' ' + house);
            build && p.push(iget2('b-vcards', 'korp', 'корп.') + ' ' + build);
            apart && p.push(iget2('b-vcards', 'ofis', 'офис') + ' ' + apart);

            return p.join(', ');
        })(
            [],
            vcard.country,
            vcard.city,
            vcard.metro && vcard.metro_name,
            vcard.street,
            vcard.house,
            vcard.build,
            vcard.apart
        ),

        worktimes = vcard.worktimes && vcard.worktimes.length && vcard.worktimes.map(function(row) {
            var days = [],
                hours = [],
                label24Hours = iget2('b-vcards', 'kruglosutochno', 'круглосуточно');

            days.push(row.d1);

            row.d2 && row.d2 !== row.d1 &&
                days.push(row.d2);

            row.h2 === '00' && row.m2 === '00' &&
                (row.h2 = '24');

            if (row.h1 === '00' && row.h2 === '24' && row.m1 === '00' && row.m2 === '00' ||
                row.d1 === iget2('b-vcards', 'pn', 'пн') && row.d2 === iget2('b-vcards', 'vs', 'вс') && row.h1 === row.h2 && row.m1 === row.m2) {

                row.h1 = label24Hours;
            }

            if (row.h1 === label24Hours) {
                hours.push(row.h1);
            } else {
                hours.push([row.h1, row.m1].join(':'));

                row.h2 && row.m2 &&
                    hours.push([row.h2, row.m2].join(':'));
            }

            return days.join('-') + ': ' + hours.join(' &ndash; ');
        }),

        person = vcard.contactperson && [iget2('b-vcards', 'kontaktnoe-lico', 'Контактное лицо'), vcard.contactperson].join(': '),

        email = vcard.contact_email,

        im = (function(client, login, ims) {
            return client && login ? [ims[client], login].join(': ') : '';
        })(vcard.im_client, vcard.im_login, {
            icq: 'ICQ',
            mail_agent: iget2('b-vcards', 'mail-ru-agent', 'Mail.ru Агент'),
            jabber: 'Jabber/GTalk',
            skype: 'Skype',
            MSN: 'MSN'
        }),

        /**
         * Вставляет в массив между элементами переданный текст + чистит массив от пустых значений (null, false, '')
         * @param {Array} array
         * @param {String} text
         * @returns {String}
         */
        inject = function(array, text) {
            return [].concat.apply(
                [],
                array
                    .filter(function(val) {
                        return !!val;
                    })
                    .map(function(val, index) {
                        return index ? [text, val] : [val]
                    }));
        };

    return [
        {
            elem: 'desc-row',
            content: inject([
                phone && {
                    elem: 'phone',
                    content: phone
                },
                address
            ], ' &nbsp; &middot; &nbsp; ')
        },
        {
            elem: 'desc-row',
            content: inject([
                worktimes && inject(
                    worktimes.map(function(worktime) {
                        return {
                            elem: 'worktime',
                            content: worktime
                        };
                    }),
                ', '),
                person,
                email && {
                    elem: 'email',
                    content: email
                },
                im && {
                    elem: 'im',
                    content: im
                }
            ], ' &nbsp; &middot; &nbsp; ')
        },
        {
            elem: 'extra-message',
            content: vcard.extra_message && u.escapeHTML(vcard.extra_message)
        }
    ];
});
