block('b-vcards')(

    js()(function() {
        return {
            cid: this.ctx.campaign.cid,
            ulogin: this.ctx.ulogin
        };
    }),

    content()(function() {
        return [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'filtration',
                        content: [
                            iget2('b-vcards', 'virtualnye-vizitki', 'Виртуальные визитки'),
                            {
                                block: 'b-dropdown-filter',
                                mix: [{
                                    block: 'b-vcards',
                                    elem: 'filter'
                                }],
                                js: {
                                    modelName: 'm-filter-vcards',
                                    modelData: {
                                        value: this.ctx.campaign.hasOwnVCards ? 'current' : 'all',
                                        archived: false
                                    }
                                },
                                popup: {
                                    js: { directions: 'bottom-left' },
                                    mods: {
                                        adaptive: 'no',
                                        animate: 'no'
                                    }
                                },
                                items: [
                                    {
                                        value: 'current',
                                        text: iget2('b-vcards', 'iz-etoy-kampanii', 'из этой кампании')
                                    },
                                    {
                                        value: 'all',
                                        text: iget2('b-vcards', 'iz-vseh-kampaniy', 'из всех кампаний')
                                    }
                                ],
                                footer: {
                                    block: 'checkbox',
                                    mods: {
                                        size: 's',
                                        toggle: 'archived'
                                    },
                                    checkboxAttrs: { autocomplete: 'off' },
                                    text: iget2('b-vcards', 'pokazyvat-arhivnye-vizitki', 'Показывать архивные визитки')
                                }
                            }
                        ]
                    },
                    {
                        elem: 'controls-box',
                        elemMods: {
                            hidden: 'yes',
                            position: 'head'
                        }
                    },
                    {
                        block: 'link',
                        mix: [{
                            block: 'b-vcards',
                            elem: 'close-frame-action',
                            elemMods: { hidden: 'yes' }
                        }],
                        mods: { pseudo: 'yes' },
                        content: iget2('b-vcards', 'vernutsya-k-spisku-vizitok', 'Вернуться к списку визиток')
                    }
                ]
            },
            {
                elem: 'content',
                mix: this.ctx.mixes && this.ctx.mixes.content,
                content: [
                // здесь происходит только шаблонизация элементов визиток, сортировка производится в runtime, так как
                // она зависит не только от cid, но и от наличия архивных баннеров, наличия баннеров в
                // принципе (нет баннеров - визитка уходит в конец и не показывается, случай когда в процессе работы
                // визитка была отвязана от вех баннеров), а также создания новой визитки (добавляется в конец, но
                // перед визитками из других кампаний)
                    {
                        elem: 'items',
                        content: this.ctx.vcards.map(function(vcard) {
                            var cid = this.ctx.campaign.cid;

                            return {
                                block: 'b-vcards',
                                elem: 'item',
                                elemMods: {
                                    'vcard-id': vcard.vcard_id,
                                    hidden: 'yes'
                                },
                                cid: cid,
                                vcard: vcard
                            }
                        }, this)
                    },
                    {
                        elem: 'frame-box',
                        elemMods: { hidden: 'yes' }
                    },
                    {
                        elem: 'error-message'
                    }
                ]
            },
            {
                elem: 'foot',
                content: {
                    elem: 'controls-box',
                    elemMods: {
                        hidden: 'yes',
                        position: 'foot'
                    }
                }
            }
        ];
    }),

    elem('banners-count').tag()('span'),

    elem('banners-counts').tag()('span'),

    elem('name').tag()('span'),

    elem('phone').tag()('span'),

    elem('email').tag()('span'),

    elem('im').tag()('span'),

    elem('worktime').tag()('span')
);
