BEM.DOM.decl('b-vcards', {

    onSetMod: {
        js: function() {
            this._cid = this.params.cid;
            this._ulogin = this.params.ulogin;

            this._filter = this.findBlockOn('filter', 'b-dropdown-filter');

            this._initEvents();

            this.refresh();
        }
    },

    onElemSetMod: {
        item: {
            js: function(elem) {
                var model = BEM.MODEL.getOne({ name: 'm-vcard', id: this.getMod(elem, 'vcard-id') });

                model
                    // при изменении названия визитки напрямую обновляем элемент
                    .on('name', 'change', function(e, data) {
                        this.findElem(elem, 'name').html(u.escapeHTML(data.value));
                    }, this)
                    // при изменении информации о кол-ве баннеров заменяем элемент banners-counts
                    .on('bannersCount', 'change', function(e, data) {
                        BEM.DOM.replace(this.findElem(elem, 'banners-counts'), BEMHTML.apply({
                            block: 'b-vcards',
                            elem: 'banners-counts',
                            bannersCount: data.value
                        }));
                    }, this)
                    // при остальных изменениях заменяем элемент description
                    .on('change', function(e, data) {
                        if (data.field !== 'bannersCount' && data.field !== 'name') {
                            BEM.DOM.replace(this.findElem(elem, 'description'), BEMHTML.apply({
                                block: 'b-vcards',
                                elem: 'description',
                                vcard: model.toJSON()
                            }));
                        }
                    }, this);
            },

            active: {
                yes: function(elem) {
                    // при выставлении active_yes сносим прозрачность
                    elem.css({ opacity: '' });

                    // элемент уходит в конец DOM узла элемента items
                    this.elem('items').append(elem);

                    // более не _hidden
                    this.delMod(elem, 'hidden');
                }
            },

            hidden: {
                yes: function(elem) {
                    // при выставлении _hidden_yes проверяем не открыт ли связанный с визиткой редактор/просмотрщик
                    this.hasMod(elem, 'framed', 'yes') && this._closeFrame();

                    // более не _active
                    this.delMod(elem, 'active');
                },

                animate: function(elem) {
                    var _this = this;

                    // анимированное схлопывание элемента с последующим выставлением _hidden_yes
                    elem.animate({ opacity: 0 }, function() {
                        _this.setMod(elem, 'hidden', 'yes');

                        // если до удалялись, что не один не _active_yes, то
                        _this.afterCurrentEvent(function() {
                            !_this.elem('item', 'active', 'yes').length ?
                                // обновляем содержимое
                                _this.refresh() :
                                // или пересчитываем позиции
                                _this.reorder();

                            if (_this.elem('item', 'created', 'yes').length ||
                                _this.elem('item', 'refresh', 'yes').length) {

                                _this.refresh();

                                _this.delMod(_this.elem('item', 'created', 'yes'), 'created');
                                _this.delMod(_this.elem('item', 'refresh', 'yes'), 'refresh');
                            }
                        });
                    });
                }
            }
        }
    },

    /**
     * Меняет состояние для контролов привязки визиток и баннеров
     * @param {Boolean} state
     */
    setAssignableState: function(state) {
        this.findBlocksOn('assign-vcard-action', 'link').forEach(function(link) {
            link.toggleMod('disabled', 'yes', !state);
        });
    },

    /**
     * Пересчёт позиций визиток
     */
    reorder: function() {
        BEM.MODEL
            .get({ name: 'm-vcard' }, true)
            .sort(this._getSortComparator())
            .forEach(function(vcard, index) {
                return vcard.set('position', index + 1);
            });
    },

    /**
     * Обновляет список визиток:
     *  - прячет все визитки
     *  - фильтрует модели
     *  - сортирует отфильтрованные
     *  - показывает отфильтрованные визитки
     *
     * Если передан список моделей визиток, то
     *  - каждая модель будет проверена на право быть показанной
     *  - если встретится модель, которая не должна показываться, она анимировано исчезнет
     *
     * Если список визиток будет пуст, то в зависимости от фильтра
     * будет показано сообщение о причинах пустого списка.
     * @param {BEM.MODEL[]} [vcardModels]
     */
    refresh: function(vcardModels) {
        var errorMessage,
            animationRunning = !!(vcardModels || []).filter(function(model) {
                var elem = this._getItemElem(model.get('vcard_id')),
                    animation = !this._isViewAllowed(model) && !!elem.length;

                animation ?
                    this.setMod(elem, 'hidden', 'animate') :
                    this.setMod(elem, 'refresh', 'yes');

                return animation;
            }, this).length;

        // выходим, если идёт процесс анимированное скрытие
        if (animationRunning) return;

        this.reorder();

        // фильтруем и сортируем
        vcardModels = BEM.MODEL.get('m-vcard')
            .filter(function(model) {
                var isViewAllowed = this._isViewAllowed(model),
                    elem = this._getItemElem(model.get('vcard_id'));

                isViewAllowed ?
                    // выключаем то, что разрешено показывать
                    this.delMod(elem, 'active') :
                    // прячем то, что не разрешено показывать
                    this.setMod(elem, 'hidden', 'yes');

                return isViewAllowed;
            }, this)
            .sort(this._getSortComparator());

        if (vcardModels.length) {
            vcardModels.forEach(function(model) {
                var elem = this._getItemElem(model.get('vcard_id'));

                // включаем то, что разрешено показывать
                this.setMod(elem, 'active', 'yes');
            }, this);
        } else {
            // если нечего показать, показываем ошибку исходя из параметров фильтрации
            errorMessage = ({
                current: iget2('b-vcards', 'v-etoy-kampanii-net-104', 'В этой кампании нет виртуальных визиток'),
                all: iget2('b-vcards', 'u-vas-net-virtualnyh', 'У вас нет виртуальных визиток')
            })[this.getFilterModel().get('value')];
        }

        this.elem('error-message').text(errorMessage || '');
    },

    /**
     * Подсветка представления визитки
     * @param {String} vcardId идентификатор визитки
     * @param {Number} [count] количество мерцаний
     * @private
     */
    highlight: function(vcardId, count) {
        var _this = this,
            elem = this._getItemElem(vcardId);

        count > 0 || (count = 1);

        elem
            .css({ backgroundColor: '#fff' })
            .animate({ backgroundColor: '#ffee99', duration: 1000 }, function() {
                elem.animate({ backgroundColor: '#fff', duration: 1000 }, function() {
                    // очистка св-ва атрибута style
                    elem.css({ background: '' });

                    count > 1 && _this.highlight(vcardId, --count);
                });
            });
    },

    /**
     * Открывает форму редактирования для редактирования/создания визитки
     * @param {String} [vcardId]
     * @param {String} [bannerId]
     */
    openEditor: function(vcardId, bannerId) {
        var type = vcardId && (bannerId ? 'target-edit' : 'common-edit') || 'create',
            params = {};

        bannerId && (params.bid = bannerId);
        vcardId && (params.vcard_id = vcardId);

        this._openFrame(type, params);
    },

    /**
     * Открывает форму просмотра визитки
     * @param {String} vcardId
     */
    openViewer: function(vcardId) {
        this._openFrame('view', { vcard_id: vcardId });
    },

    /**
     * Добавляет визитку как модель и представление
     * @param {Object} vcardData
     */
    addCreatedVCard: function(vcardData) {
        var model;

        vcardData.bannersCount = { total: 0, active: 0 };

        model = BEM.MODEL.create({ name: 'm-vcard', id: vcardData.vcard_id }, vcardData);

        BEM.DOM.append(this.elem('items'), BEMHTML.apply({
            block: 'b-vcards',
            elem: 'item',
            mods: { 'vcard-id': model.get('vcard_id'), hidden: 'yes', created: 'yes' },
            cid: this._cid,
            vcard: model.toJSON()
        }));

        return model;
    },

    /**
     * Возвращает модель фильтра
     * @returns {BEM.MODEL}
     */
    getFilterModel: function() {
        return this._filter.model;
    },

    /**
     * Перерисовка контролов управления визиткой вокруг блока
     * @param {String} [mode] выбранный режим отображения контролов
     * @param {Object} [params] параметры с идентификаторами моделей для передачи моделей в шаблон
     * @private
     */
    _redrawControls: function(mode, params) {
        var vcard,
            banner,
            hasContent;

        if (params) {
            params.vcard_id &&
                (vcard = BEM.MODEL.getOne({ name: 'm-vcard', id: params.vcard_id }).toJSON());

            params.bid &&
                (banner = BEM.MODEL.getOne({ name: 'm-banner', id: params.bid }).toJSON());
        }

        hasContent = !!['head', 'foot'].filter(function(position) {
            var content,
                isEmpty,
                elem = this.elem('controls-box', 'position', position);

            mode &&
                (content = BEMHTML.apply({
                    block: 'b-vcards',
                    elem: 'controls',
                    elemMods: { mode: mode, position: position },
                    cid: this._cid,
                    vcard: vcard,
                    banner: banner
                }));

            isEmpty = !content;

            this.toggleMod(elem, 'hidden', 'yes', isEmpty);

            BEM.DOM.update(elem, content);

            return !isEmpty;
        }, this).length;

        this
            .toggleMod(this.elem('filtration'), 'hidden', 'yes', hasContent)
            .toggleMod(this.elem('close-frame-action'), 'hidden', 'yes', !hasContent);
    },

    /**
     * Показать список визиток
     * @private
     */
    _closeFrame: function() {
        this.delMod('frame-type');

        this.delMod(this.elem('item', 'framed', 'yes'), 'framed');

        this._redrawControls();

        BEM.DOM.update(
            this.elem('frame-box'),
            '',
            function() {
                this._switchView('items');

                this.trigger('frame-close');
            },
            this);
    },

    /**
     * Показать фрэйм с содержимым страницы в зависимости от переданных параметров
     * @param {String} type режим содержимого фрэйма
     * @param {Object} params хэш с GET параметрами для фрэйма
     * @private
     */
    _openFrame: function(type, params) {
        var cmd = ({
            view: 'showContactInfo',
            create: 'editVCard',
            'common-edit': 'editVCard',
            'target-edit': 'editVCard'
        })[type];

        this.setMod('frame-type', type);

        params.vcard_id &&
            this.setMod(this._getItemElem(params.vcard_id), 'framed', 'yes');

        this.trigger('frame-opening');

        this._redrawControls(type, params);

        params = $.extend({
            cid: this._cid,
            ulogin: this._ulogin
        }, params);

        BEM.DOM.update(
            this.elem('frame-box'),
            BEMHTML.apply([
                { block: 'spin', mods: { progress: 'yes', theme: 'gray-48' } },
                { block: 'b-iframe', mods: { hidden: 'yes' }, src: u.getUrl(cmd, params) }
            ]),
            function(ctx) {
                var spinner = this.findBlockInside(ctx, 'spin'),
                    frame = this.findBlockInside(ctx, 'b-iframe');

                // навешиваемся на события в iframe до его загрузки с целью перехвата событий
                cmd === 'editVCard' && this._initEditFrameEvents(frame);

                frame.on('load', function() {
                    spinner && spinner.destruct();

                    frame.delMod('hidden');
                }, this);

                this._switchView('frame-box');
            },
            this);
    },

    /**
     * Переключает отображение: делает видимым отображение соответствующее переданному имени
     * @param {String} elemName
     * @private
     */
    _switchView: function(elemName) {
        ['items', 'frame-box'].forEach(function(name) {
            this.toggleMod(this.elem(name), 'hidden', 'yes', elemName !== name);
        }, this);
    },

    /**
     * Возвращает компаратор для сортировки моделей визиток
     * @returns {Function}
     * @private
     */
    _getSortComparator: function() {
        var cid = this._cid;

        return function(model1, model2) {
            var currentCamp1 = model1.get('cid') === cid,
                currentCamp2 = model2.get('cid') === cid,

                // в процессе работы визитка может быть отвязана от всех баннеров,
                // в таком случае она не удаляется из DOM, но уходит при сортировке в самый конец, поэтому
                // используем показатели моделей, выпадающих в самый конец списка
                unlinked1 = currentCamp1 && !model1.get('bannersCount').total,
                unlinked2 = currentCamp2 && !model2.get('bannersCount').total;

            // выталкиваем в конец списка в приоритетном порядке:
            return (unlinked1 - unlinked2) || // - визитки, которые не привязаны к баннерам
                (currentCamp2 - currentCamp1) || // - визитки не из этой кампании
                (model1.get('isArchived') - model2.get('isArchived')) || // - визитки, которые привязаны только к архивным баннерам
                (model2.get('vcard_id') - model1.get('vcard_id')); // - визитки, имеющие меньший идентификатор
        };
    },

    /**
     * Дозволено ли модели отображаться или нет
     * @param {BEM.MODEL} vcardModel модель визитки
     * @returns {Boolean}
     * @private
     */
    _isViewAllowed: function(vcardModel) {
        // важно приведение к одному типу, т.к. с бэкенда приходит число
        var isCurrent = +vcardModel.get('cid') === +this._cid,
            filterModel,
            filterValue;

        // отсеивание визиток текущей кампании без привязанных к ним баннеров
        if (isCurrent && !vcardModel.get('bannersCount').total) return false;

        filterModel = this.getFilterModel();

        // отсеивание архивных визиток, если фильтр не просит архивные
        if (!filterModel.get('archived') && vcardModel.get('isArchived')) return false;

        filterValue = filterModel.get('value');

        if (filterValue === 'all') return true;

        if (filterValue === 'current') return isCurrent;

        return false;
    },

    /**
     * Shortcut для получения элемента визитки
     * @param {String} vcardId идентификатор визитки
     * @returns {jQuery}
     * @private
     */
    _getItemElem: function(vcardId) {
        return this.elem('item', 'vcard-id', vcardId);
    },

    /**
     * Подписка на канальные события
     * @private
     */
    _initEditFrameEvents: function(frame) {
        frame
            .getEventBus()
            // подтверждение редактирования визитки
            // это нужно, чтобы b-confirm работал в рамках страницы, так как форма редактирования живет
            // в iframe и там b-comfirm будет ограничен страницей iframe
            .on('edit-confirm', function(e, data) {
                var dfd = data.promise;

                // в загружаемом фрэйме есть свой диалог на это событие
                // блокируем его открытие тут
                e.stopPropagation();

                BEM.blocks['b-confirm'].open({
                    message: data.confirm,
                    onYes: function() { dfd.resolve(true) },
                    onNo: function() { dfd.resolve(false) }
                });
            })

            // при отмене или завершении редактирования закрываем фрэйм
            .on('edit-canceled edit-completed', this._closeFrame, this)

            // при завершении редактирования
            .on('edit-completed', function(e, data) {
                var model,
                    vcard = data.new_vcard;

                if (vcard) {
                    vcard.vcard_id &&
                        (model = BEM.MODEL.getOne({ name: 'm-vcard', id: vcard.vcard_id }));

                    model ||
                        (model = this.addCreatedVCard(vcard));

                    model.update(vcard);

                    this.trigger('create-vcard', {
                        vcardId: model.get('vcard_id'),
                        oldVCardId: data.old_vcard_id
                    });
                }
            }, this);
    },

    /**
     * Инициализация событий блока
     * @private
     */
    _initEvents: function() {
        this._filter
            .findBlockInside('footer', { block: 'checkbox', modName: 'toggle', modVal: 'archived' })
            .on('change', function(e) {
                this.getFilterModel().update({ archived: e.target.isChecked() });
            }, this);

        this.getFilterModel().on('change', function() { this.refresh(); }, this);

        this.findBlockOn('close-frame-action', 'link').on('click', this._closeFrame, this);
    }

}, {

    live: true

});
