block('b-video-extension')(

    match(function() {
        return !this.mods.disabled;
    }).def()(function() {
        return applyNext({
            'mods.action': u._.isEmpty(this.ctx.video) ? 'add' : 'edit'
        });
    }),

    js()(function() {
        return {
            clientId: this.ctx.clientId,
            strategy: this.ctx.strategy,
            hasImage: this.ctx.hasImage,
            disable_videomotion: this.ctx.disable_videomotion,
            video: this.ctx.video,
            groupType: this.ctx.groupType
        };
    }),

    content()(function() {
        return [
            {
                elem: 'selector'
            },
            {
                elem: 'label',
                video: this.ctx.video,
                hasImage: !!this.ctx.hasImage,
                isNetStop: !!this.ctx.strategy.is_net_stop,
                disable_videomotion: !!this.ctx.disable_videomotion
            },
            {
                elem: 'delete'
            }
        ];
    }),

    mod('disabled', 'yes').content()(function() {
        return {
            elem: 'label',
            video: this.ctx.video,
            hasImage: !!this.ctx.hasImage,
            isNetStop: !!this.ctx.strategy.is_net_stop,
            disable_videomotion: !!this.ctx.disable_videomotion
        }
    }),

    elem('selector').replace()(function() {
        return {
            block: 'b-video-creative-selector',
            mix: { block: 'b-video-extension', elem: 'selector' },
            mods: { action: 'add' }
        };
    }),

    elem('label').content()(function() {
        var video = this.ctx.video || {},
            hasVideo = !!video.id ,
            hasVideoMotion = !this.ctx.disable_videomotion && this.ctx.hasImage,
            hasPreview = !this.ctx.isNetStop && (hasVideo || hasVideoMotion),
            text = hasVideo ?
                video.name :
                hasVideoMotion ?
                    iget2('b-video-extension', 'devault-videoMotion', 'Видеодополнение по умолчанию') :
                    iget2('b-video-extension', 'no-videoMotion', 'Видеодополнение отсутствует'),
            hint = !this.ctx.isNetStop ? '' : iget2(
                'b-video-extension',
                'net-stop-hint',
                'Объявления с видеодополнениями показываются только в сетях. Сейчас кампания показывается только на поиске.');

        return hasPreview ?
            { elem: 'video-link', text: text } :
            { elem: 'video-name', text: text, hint: hint };
    }),

    elem('delete').replace()(function() {
        return {
            block: 'button',
            mods: { size: 'xs', theme: 'icon', 'only-icon': 'yes' },
            mix: { block: 'b-video-extension', elem: 'delete' },
            attrs: { title: iget2('b-video-extension', 'udalit', 'Удалить') },
            content: {
                block: 'icon',
                mods: { 'size-16': 'delete', theme: 'light' },
                mix: { block: 'button', elem: 'icon' }
            }
        };
    }),

    elem('video-link').replace()(function() {
        return {
            block: 'link',
            mods: { pseudo: 'yes', theme: 'without-border' },
            mix: { block: 'b-video-extension', elem: 'video-link' },
            content: u.escapeHTML(this.ctx.text)
        };
    }),

    elem('video-name').content()(function() {
        var hint = this.ctx.hint;

        return {
            block: 'link',
            mods: { pseudo: 'yes' },
            mix: [
                { block: 'b-video-extension', elem: 'video-name' },
                !!hint && {
                    block: 'b-hintable',
                    js: { hint: hint }
                }
            ],
            content: u.escapeHTML(this.ctx.text)
        }
    })

);
