/**
 *
 * @param {Boolean} [hasImage] - признак: объявления имеет картинку
 * @param {Boolean} [disable_videomotion] - признак: запрещены видеодополнения по умолчанию
 *
 * @param {Object} [video] - информация о видео
 * @param {String} [video.name] - название
 * @param {Number} [video.id] - идентификатор
 *
 * @param {Object} strategy - информация о стратегии кампании // https://st.yandex-team.ru/DIRECT-63936#1495547463000
 * @param {Boolean} strategy.is_net_stop - есть ли показы в сетях
 *
 * @fires b-video-extension#add событие добавления нового видеодополнения
 * @fires b-video-extension#delete событие удаления видеодополнения
 * @fires b-video-extension#show событие, возникающее при клике на ссылку с названием видео
 */
BEM.DOM.decl('b-video-extension', {

    onSetMod: {

        js: function() {
            this._selector = {};
            this._video = this.params.video;
            this._hasImage = this.params.hasImage;
            this._isNetStop = this.params.strategy.is_net_stop;
            this._disable_videomotion = this.params.disable_videomotion;
            this._groupType = this.params.groupType;
        },

        action: function(modName, modVal) {
            BEM.DOM.replace(
                this.findElem('selector'),
                this._getSelector(modVal)
            );
        },

        disabled: function(modName, modVal) {
            this.findBlockInside('b-video-creative-selector').setMod('disabled', modVal);
        }

    },

    /**
     * Возвращает блок с вариантами для выбора
     * @param {add|edit} action - вид действия
     * @return {*}
     * @private
     */
    _getSelector: function(action) {
        return this._selector[action] || (this._selector[action] = BEMHTML.apply({
            block: 'b-video-extension',
            mods: {
                action: action
            },
            elem: 'selector'
        }));
    },

    _updateLabel: function() {
        BEM.DOM.replace(
            this.findElem('label'),
            BEMHTML.apply({
                block: 'b-video-extension',
                elem: 'label',
                video: this._video,
                hasImage: this._hasImage,
                isNetStop: this._isNetStop,
                disable_videomotion: this._disable_videomotion
            })
        );
    },

    /**
     * Переключает в режим редактирования/удаления видео
     * @param {VideoExtension} video - данные нового видеодополнения
     */
    switchToEdit: function(video) {
        this._video = video;

        this.setMod('action', 'edit');
        this._updateLabel();
    },

    /**
     * Переключает блок в режим добавления видео
     */
    switchToAdd: function() {
        this._video = null;
        this.setMod('action', 'add');
        this._updateLabel();
    },

    /*
     * Обновляет значение поля hasImage
     */
    updateImageFlag: function(hasImage) {
        this._hasImage = !!hasImage;
        this._updateLabel();
    },

    /**
     * Обработчик событий взаимодействия с видео
     * @param {Event} e
     * @param {new|edit|recent} type - тип взаимодействия
     * @private
     */
    _onSelect: function(e, type) {
        this._openCanvasWindow(type);
    },

    /**
     * Открытие креатива
     * @param {new|edit|recent} type - тип взаимодействия
     * @private
     */
    _openCanvasWindow: function(type) {
        var extraParams = { creativeId: u._.get(this._video, 'id'), groupType: this._groupType };

        switch (type) {
            case 'new':
                this._getCanvasFrame()
                    .show('presets', this.params.clientId, extraParams);
                break;

            case 'edit':
                this._getCanvasFrame()
                    .show('edit', this.params.clientId, extraParams);
                break;

            case 'recent':
                this._getCanvasFrame()
                    .show('creatives', this.params.clientId, extraParams);
                break;
        }
    },

    /**
     * Инициализирует и возвращает блок для создания/выбора креативов через конструктор
     * @return {BEM.DOM<b-banner-storage-selector>} блок для создания/выбора креативов через конструктор
     * @private
     */
    _getCanvasFrame: function() {
        var self = this,
            bannerEditBlock = self.findBlockOutside('b-edit-banner2'),
            bannerPcodeData,
            uploader;

        if (self.hasMod('mass-actions') || !bannerEditBlock) {
            bannerPcodeData = u['b-banner-preview2']
                .getEmptyDataToPcode();
        } else {
            bannerPcodeData = u['b-banner-preview2']
                .getDataToPcode(bannerEditBlock.findBlockInside('b-banner-preview2'));
        }

        uploader = BEM.DOM.blocks['b-banner-storage-frame'].create({
            type: 'video'
        }, bannerPcodeData.ads[0]);

        uploader.on('select', function(e, creative) {
            if (creative.length) {
                this._onCreativeCreate(creative[0]);
            } else {
                BEM.blocks['b-confirm'].alert(iget2(
                    'b-video-extension',
                    'proizoshla-oshibka-pozhaluysta-povtorite',
                    'Произошла ошибка. Пожалуйста, повторите попытку позже.'
                ));
            }
        }, this);

        uploader.on('close', function() {
            uploader.destruct();
        });

        uploader.on('ready', function() {
            var bannerEditBlock,
                bannerPcodeData,
                message;

            if (self.hasMod('mass-actions')) {
                bannerPcodeData = u['b-banner-preview2']
                    .getEmptyDataToPcode();
            } else {
                bannerEditBlock = self.findBlockOutside('b-edit-banner2');
                bannerPcodeData = u['b-banner-preview2']
                    .getDataToPcode(bannerEditBlock.findBlockInside('b-banner-preview2'));
            }

            message = {
                type: 'video-addition-preview',
                data: bannerPcodeData.ads[0]
            };

            uploader.postMessage(JSON.parse(JSON.stringify(message)), '*');
        });

        return uploader;
    },

    /**
     * Обработчик создания видеодополнения
     * @param {Object} creative
     * @private
     */
    _onCreativeCreate: function(creative) {
        this.trigger('add', {
            id: creative.id,
            name: creative.name,
            preview_url: creative.preview_url,
            resource_type: 'creative',
            live_preview_url: creative.live_preview_url
        });
    },

    /**
     * Обработчик события нажатия на кнопку удаления видеодополнения
     * @private
     */
    _onDeleteButtonClick: function() {
        this.trigger('delete');
    },

    /**
     * Обработчик события нажатия на ссылку с названием видео
     * @private
     */
    _onVideoLinkClick: function() {
        this.trigger('show');
    }

},{
    live: function() {

        this.liveInitOnBlockInsideEvent('select', 'b-video-creative-selector', function(e, data) {
            this._onSelect(e, data);
        });

        this.liveBindTo('delete', 'click', function() {
            this._onDeleteButtonClick();
        });

        this.liveBindTo('video-link', 'click', function() {
            this._onVideoLinkClick();
        });

    }
});
