/**
 * @param {String} ctx.url - адрес страницы
 * @param {String} [ctx.clickUrl] url перехода по клику для ГО
 * @param {Number} [ctx.width] - ширина фрейма
 * @param {Number} [ctx.height] - высота фрейма
 * @param {Boolean} [ctx.autostart] - требуется ли автозапуск
 * @param {Boolean} [ctx.containerRatio] - Пропорции контейнера для превью
 * @param {DataToPcode.ads[]} ctx.banner - данные баннера
 */
block('b-video-preview')(

    js()(function() {
        var ctx = this.ctx;

        return {
            banner: ctx.banner,
            autostart: ctx.autostart,
            url: ctx.url,
            width: ctx.width,
            height: ctx.height,
            clickUrl: ctx.clickUrl
        }
    }),

    content()(
        match(function() {
            return this.ctx.url;
        })(function() {
            var ctx = this.ctx,
                style,
                width = ctx.width,
                height = ctx.height;

            if (width && height) {
                style = 'width: ' + width + 'px; height: ' + height + 'px;'
            }

            return {
                elem: 'dna-video-preview-wrapper',
                content: {
                    block: 'dna-video-preview',
                    mix: { block: 'b-video-preview' },
                    attrs: {
                        style: style
                    }
                }
            };
        }),

        match(function() {
            return !this.ctx.url;
        })(function() {
            return {
                elem: 'no-video',
                content: {
                    elem: 'content',
                    content: [
                        {
                            elem: 'text',
                            content: iget2(
                                'b-video-preview',
                                'dlya-etogo-obyavleniya-videodopolnenie',
                                'Для этого объявления видеодополнение выключено. Вы можете добавить его в конструкторе.'
                            )
                        },
                        {
                            elem: 'text',
                            content: {
                                block: 'b-help-link',
                                icon: '',
                                url: u.getCommonHelpUrl('direct/features/video-extension.html'),
                                text: iget2('b-video-preview', 'podrobnee-o-videodopolneniyah', 'Подробнее о видеодополнениях')
                            }
                        }
                    ]
                }
            }
        })
    )
);
