/**
 * @param {Boolean} [autostart] - требуется ли автозапуск
 * @param {DataToPcode.ads[]} banner - данные баннера
 */
BEM.DOM.decl({ name: 'b-video-preview', implements: 'i-preview-tab-interface' }, {

    onSetMod: {
        js: function() {
            this._autostart = this.params.autostart;
        }
    },

    /**
     * Запускает проигрывание превью
     */
    play: function() {
        this.onEnable();
    },

    /**
     * Останавливает проигрывание превью
     */
    stop: function() {
        this.onDisable();
    },

    /**
     * Вызывается при активации превью
     */
    onEnable: function() {
        this._renderDnaVideoPreview();
    },

    /**
     * Вызывается при выключении превью
     */
    onDisable: function() {
        var dnaVideoPreview = this.findBlockInside('dna-video-preview');

        if (!dnaVideoPreview) {
            return;
        }

        window.dna.reactDOMUnmount(dnaVideoPreview.domElem[0]);
        BEM.DOM.destruct(dnaVideoPreview.domElem, true);
    },

    _renderDnaVideoPreview: function() {
        var dna = window.dna;
        if (!dna) {
            return;
        }
        var dnaVideoPreview = this.findBlockInside('dna-video-preview');

        if (!dnaVideoPreview) {
            return;
        }

        var preview,
            url = this.params.url,
            previewBlock = dnaVideoPreview.domElem[0];

        if (url.indexOf('/video-additions/') >= 0 || url.indexOf('/creative-preview/video/') >= 0) {
            var size = u._.pick(this.params, ['width', 'height']);

            preview = dna.reactCreateElement(
                dna.components.VideoCreativePreview,
                {
                    previewUrl: url,
                    previewData: {
                        size: size,
                        ads: [this.params.banner]
                    },
                    ratio: size, // передаем ширину и высоту в качестве ratio
                    tld: u.consts('tld'),
                    cspNonce: BEM.blocks['i-global'].param('nonce')
                },
                null
            );

        } else {
            preview = dna.reactCreateElement(
                dna.components.ImageCreativePreview,
                {
                    previewUrl: url,
                    width: this.params.width,
                    height: this.params.height,
                    clickUrl: this.params.clickUrl,
                    cspNonce: BEM.blocks['i-global'].param('nonce'),
                    parentNode: { current: previewBlock }
                },
                null
            );
        }

        dna.reactDOMRender(
            preview,
            previewBlock
        )
    },

    destruct: function() {
        this.__base.apply(this, arguments);
    }

});
