block('b-wallet-campaigns-rests')(

    js()(true),

    content()(function() {
        var ctx = this.ctx,
            campaigns = ctx.campaigns,
            restsTotal = campaigns.reduce(function(res, campaign) {
                return res += +campaign.total;
            }, 0);

        return [
            {
                block: 'dropdown',
                content: [
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        mix: [
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            },
                            {
                                block: 'b-wallet-campaigns-rests',
                                elem: 'info-link'
                            },
                            {
                                block: 'b-metrika2',
                                js: {
                                    nativeEvent: 'click',
                                    params: {
                                        showCamps: 'showCampaignRests'
                                    }
                                }
                            }
                        ],
                        content: u.currencies.formatSum(ctx.currency, restsTotal)
                    },
                    {
                        elem: 'popup',
                        elemMods: {
                            'has-close': 'yes',
                            'with-controls': 'yes'
                        },
                        js: { directions: ['right'] },
                        content: [
                            {
                                elem: 'title',
                                content: iget2('b-wallet-campaigns-rests', 'ostatki-sredstv-na-kampaniyah', 'Остатки средств на кампаниях')
                            },
                            {
                                block: 'b-wallet-campaigns-rests',
                                elem: 'content',
                                mix: [{
                                    block: 'popup',
                                    elem: 'body'
                                }],
                                content: [

                                    {
                                        elem: 'comment',
                                        content: iget2(
                                            'b-wallet-campaigns-rests',
                                            'ostatok-sredstv-na-kampanii',
                                            'Остаток средств на кампании возникает в процессе корректировки статистики. Его невозможно перенести на другую кампанию или общий счёт. {href}',
                                            {
                                                href: function(text) {
                                                    return {
                                                        block: 'b-help-link',
                                                        mods: { type: 'modal' },
                                                        stretched: true,
                                                        text: text,
                                                        url: u.getHelpUrl('campaigns-balance')
                                                    };
                                                }(iget2('b-wallet-campaigns-rests', 'ostatok-sredstv-na-kampanii-param-href', 'Подробнее')),

                                                context: 'href - Подробнее'
                                            }
                                        )
                                    },
                                    {
                                        elem: 'wrapper',
                                        content: {
                                            elem: 'table',
                                            content: campaigns.map(function(campaign) {
                                                return {
                                                    block: 'b-wallet-campaigns-rests',
                                                    elem: 'campaign',
                                                    campaign: campaign,
                                                    ulogin: ctx.ulogin,
                                                    currency: ctx.currency
                                                };
                                            })
                                        }
                                    }
                                ]
                            }
                        ]

                    }
                ]
            }
        ];
    }),

    elem('campaign').content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'td',
                content: [
                    {
                        block: 'link',
                        url: u.getUrl('showCamp', {
                            cid: ctx.campaign.cid,
                            ulogin: ctx.ulogin
                        }),
                        mix: [{
                            block: 'b-wallet-campaigns-rests',
                            elem: 'campaign-name'
                        }],
                        content: ctx.campaign.name
                    },
                    {
                        elem: 'campaign-num',
                        content: [
                            '&#x2116;&nbsp;',
                            ctx.campaign.cid,
                            '&nbsp;'
                        ]
                    }
                ]
            },
            {
                elem: 'td',
                mix: [{
                    block: 'b-wallet-campaigns-rests',
                    elem: 'rest'
                }],
                content: u.currencies.formatSum(ctx.currency, +ctx.campaign.total, {
                    delim: '&nbsp;'
                })
            }
        ];
    }),

    elem('campaign').tag()('tr'),

    elem('table').tag()('table'),

    elem('td').tag()('td')
);
