block('b-wallet-day-budget-control')(

    def()(function() {
        this.ctx.mode = this.ctx.mode || 'default';

        return applyNext();
    }),

    js()(function() {
        var ctx = this.ctx,
            modelData = {
                set: ctx.isActive,
                sum: ctx.value,
                show_mode: ctx.mode,
                currency: ctx.currency
            };

        if (ctx.isCommonWallet) {
            modelData.minValue = u.currencies.get(ctx.currency).MIN_WALLET_DAY_BUDGET;
        }

        return {
            modelName: 'm-day-budget',
            modelData: modelData
        }
    }),

    content()(function() {
        var selectedModeOption,
            modeOptions = [
                {
                    elem: 'option',
                    attrs: { value: 'default' },
                    content: u['text-store'].get('dayBudget', 'mode', 'default')
                },
                {
                    elem: 'option',
                    attrs: { value: 'stretched' },
                    content: u['text-store'].get('dayBudget', 'mode', 'stretched')
                }
            ];

        selectedModeOption = u._.find(modeOptions, function(option) {
            return option.attrs.value == this.ctx.mode;
        }, this);

        selectedModeOption.attrs.selected = 'selected';

        return [
            {
                elem: 'controls',
                content: [
                    {
                        block: 'tumbler',
                        mods: {
                            size: 's',
                            checked: this.ctx.isActive ? 'yes' : ''
                        },
                        mix: [
                            {
                                block: 'b-wallet-day-budget-control',
                                elem: 'switcher'
                            },
                            {
                                block: 'b-wallet-day-budget-control',
                                elem: 'model-field',
                                js: {
                                    name: 'set',
                                    type: 'tumbler'
                                }
                            }
                        ]
                    },
                    {
                        elem: 'value',
                        content: iget2('b-wallet-day-budget-control', 'input-10-currency-rub', '{input} {currency} в день', {
                            input: {
                                block: 'input',
                                mods: {
                                    size: 's',
                                    theme: 'normal',
                                    clear: 'no'
                                },
                                mix: [
                                    {
                                        block: 'b-wallet-day-budget-control',
                                        elem: 'value-input'
                                    },
                                    {
                                        block: 'b-wallet-day-budget-control',
                                        elem: 'model-field',
                                        js: {
                                            name: 'sum',
                                            type: 'input'
                                        }
                                    }
                                ],
                                value: u.numberFormatter.format(this.ctx.value, { fail: '' }),
                                content: [
                                    { elem: 'control' }
                                ]
                            },

                            currency: u.currencies.getName(this.ctx.currency),
                            context: 'input - 10; currency - руб.'
                        })
                    },
                    {
                        elem: 'mode',
                        content: iget2('b-wallet-day-budget-control', 'rezhim-pokaza-select-standartnyy', 'Режим показа {select}', {
                            select: {
                                block: 'select',
                                js: false,
                                mods: {
                                    size: 's',
                                    theme: 'normal'
                                },
                                mix: [
                                    {
                                        block: 'b-wallet-day-budget-control',
                                        elem: 'mode-select'
                                    },
                                    {
                                        block: 'b-wallet-day-budget-control',
                                        elem: 'model-field',
                                        js: {
                                            name: 'show_mode',
                                            type: 'select'
                                        }
                                    }
                                ],
                                content: [
                                    {
                                        block: 'button',
                                        mix: {
                                            block: 'b-wallet-day-budget-control',
                                            elem: 'mode-select-button'
                                        },
                                        content: selectedModeOption.content
                                    },
                                    {
                                        block: 'select',
                                        elem: 'control',
                                        content: modeOptions
                                    }
                                ]
                            },

                            context: 'select - стандартный,распределённый'
                        })
                    }
                ]
            },
            {
                elem: 'errors',
                elemMods: {
                    hidden: 'yes'
                }
            }
        ];
    })
);
