/**
 * @fires b-wallet-day-budget-control#change изменение настроек контрола дневного бюджета
 */
BEM.DOM.decl({ name: 'b-wallet-day-budget-control', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._switcher = this.findBlockOn('switcher', 'tumbler');
            this._valueInput = this.findBlockOn('value-input', 'input');
            this._modeSelect = this.findBlockOn('mode-select', 'select');

            this._subscriptionManager.wrap(this.model)
                .on('change', function() {
                    this._hideError();
                    this.trigger('change');
                }, this)
                .on('set', 'change', this._onActiveStateChange, this)
                .on('validated', this._onModelValidate, this);

            this._onActiveStateChange();
        },

        active: function(modName, newValue) {
            var isActive = newValue === 'yes',
                _this = this;

            _this._valueInput.toggleMod('disabled', 'yes', !isActive);
            _this._modeSelect.toggleMod('disabled', 'yes', !isActive);

            // чтобы фокус корректно поставить в поле, нужно чтобы окно попапа было видимо
            // и закончилась анимация тумблера с последующей установкой фокуса на него
            // поэтому дожидаемся окончания всех этих событий и только потом устанавливаем модификатор
            u._.delay(function() {
                isActive && _this._valueInput.setMod('focused', 'yes');
            }, 200);
        }
    },

    /**
     * Возвращает выбранные значения контролов дневного бюджета
     * @returns {{isActive: Boolean, value: (Number|undefined), mode: ('default'|'stretched')}}
     */
    getData: function() {

        return {
            isActive: this.model.get('set'),
            value: this.model.get('sum'),
            mode: this.model.get('show_mode')
        }
    },

    /**
     * Валидирует форму
     * @returns {Boolean}
     */
    validate: function() {
        var validationResult = this.model.validate();

        return !!validationResult.valid;
    },

    /**
     * Показывает ошибки валидации
     * @param {String} errorText текст ошибки
     * @private
     */
    showError: function(errorText) {
        BEM.DOM.update(this.elem('errors'), errorText);
        this.delMod(this.elem('errors'), 'hidden');
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события изменения состояния включенности/выключенности бюджета
     */
    _onActiveStateChange: function() {
        var isActive = this.model.get('set');

        this.setMod('active', isActive ? 'yes' : 'no');
        !isActive && this.model.set('sum', undefined);
    },

    /**
     * Обработчик события валидации модели бюджета
     * @param {Event} e
     * @param {Object} validation
     */
    _onModelValidate: function(e, validation) {
        var errorWithText;

        if (validation.valid) {
            this._hideError();
        } else {
            errorWithText = u._.find(validation.errors, function(errorItem) {
                return !!errorItem.text;
            });

            errorWithText && this.showError(errorWithText.text);
        }
    },

    /**
     * Скрывает ошибки валидации
     * @private
     */
    _hideError: function() {
        this.setMod(this.elem('errors'), 'hidden', 'yes');
        BEM.DOM.update(this.elem('errors'), '');
    }
});
