block('b-wallet-day-budget-popup')(

    js()(function() {

        return {
            cid: this.ctx.cid
        }
    }),

    content()(function() {

        return [
            {
                block: 'popup',
                elem: 'header',
                content: [
                    {
                        block: 'popup',
                        elem: 'title',
                        content: [
                            iget2('b-wallet-day-budget-popup', 'ogranichenie-byudzheta', 'Ограничение бюджета'),
                            this.ctx.helpLink && {
                                block: 'b-help-link',
                                mods: { type: 'modal' },
                                mix: {
                                    block: 'b-wallet-day-budget-popup',
                                    elem: 'help-link'
                                },
                                stretched: true,
                                url: this.ctx.helpLink
                            }
                        ]
                    },
                    this.ctx.note && {
                        block: 'popup',
                        elem: 'header-note',
                        content: this.ctx.note
                    }
                ]
            },
            {
                elem: 'body',
                mix: {
                    block: 'popup',
                    elem: 'body'
                },
                content: [
                    {
                        block: 'b-wallet-day-budget-control',
                        mix: {
                            block: 'b-wallet-day-budget-popup',
                            elem: 'control'
                        },
                        isActive: this.ctx.isActive,
                        value: this.ctx.value,
                        mode: this.ctx.mode,
                        currency: this.ctx.currency,
                        isCommonWallet: this.ctx.isCommonWallet
                    },
                    {
                        elem: 'loading-pane',
                        content: {
                            block: 'spin2',
                            mods: {
                                size: 'm'
                            },
                            mix: {
                                block: 'b-wallet-day-budget-popup',
                                elem: 'loader'
                            }
                        }
                    }
                ]
            },
            {
                block: 'popup',
                elem: 'footer',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action', size: 's', disabled: this.ctx.isSaveActive ? 'no' : 'yes' },
                        mix: [
                            { block: 'popup', elem: 'footer-button' },
                            { block: 'b-wallet-day-budget-popup', elem: 'save' }
                        ],
                        content: iget2('b-wallet-day-budget-popup', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mods: { size: 's' },
                        mix: [
                            { block: 'popup', elem: 'footer-button' },
                            { block: 'b-wallet-day-budget-popup', elem: 'cancel' }
                        ],
                        content: iget2('b-wallet-day-budget-popup', 'otmena', 'Отмена')
                    }
                ]
            }
        ];
    })
);
