/**
 * @event b-wallet-day-budget#save
 * @type {Object}
 * @property {Boolean} isActive
 * @property {Number|undefined} value
 * @property {'default'|'stretched'} mode
 *
 * @fires b-wallet-day-budget#cancel отмена изменений попапа
 * @fires b-wallet-day-budget#save-click запрос на сохранение данных дневного бюджета
 * @fires b-wallet-day-budget#save данные дневного бюджета успешно сохранены
 */
BEM.DOM.decl('b-wallet-day-budget-popup', {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _saveBtn: 'button on save',
                _cancelBtn: 'button on cancel',
                _loader: 'spin2 on loader',
                _dayBudgetControl: 'b-wallet-day-budget-control on control'
            });

            this._subscriptionManager.on(this._dayBudgetControl, 'change', function() {
                this._saveBtn.delMod('disabled');
            }, this);

            this._initData = this._dayBudgetControl.getData();

            this._subscriptionManager.on(this._saveBtn, 'click', this._onSaveButtonClicked, this);
            this._subscriptionManager.on(this._cancelBtn, 'click', this._onCancelButtonClicked, this);
        },

        loading: function(modName, modValue) {
            this._saveBtn.setMod('disabled', modValue === 'yes' ? 'yes' : '');
            this._loader.setMod('progress', modValue === 'yes' ? 'yes' : '');
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
    * Обработчик события клика на кнопку сохранения
    */
    _onSaveButtonClicked: function() {
        var dayBudgetControlData = this._dayBudgetControl.getData(),
            validationResult = this._dayBudgetControl.validate(),
            _this = this;

        _this.trigger('save-click');

        if (validationResult) {
            _this.setMod('loading', 'yes');

            BEM.blocks['i-day-budget-dataprovider'].updateData({
                cid: this.params.cid,
                dayBudgetData: {
                    set: dayBudgetControlData.isActive,
                    sum: dayBudgetControlData.value,
                    show_mode: dayBudgetControlData.mode
                }
            }).then(function(data) {
                _this.delMod('loading');

                if (data.error) {
                    _this._dayBudgetControl.showError(data.error);
                } else {
                    _this.trigger('save', dayBudgetControlData);
                    _this._sendMetrikaGoal(_this._initData, dayBudgetControlData);
                    _this._initData = dayBudgetControlData;
                }
            }, function() {
                _this.delMod('loading');

                _this._dayBudgetControl
                    .showError(iget2(
                    'b-wallet-day-budget-popup',
                    'oshibka-pri-sohranenii-ogranicheniya',
                    'Ошибка при сохранении ограничения дневного бюджета. Попробуйте ещё раз.'
                ));
            });
        }
    },

    _sendMetrikaGoal: function(initValue, newValue) {
        BEM.blocks['b-metrika2']
            .getCounter()
            .done(function(counter) {
                var initLimit = initValue.value || 0,
                    newLimit = newValue.value || 0;

                if (initValue.isActive && !newValue.isActive) {
                    counter.reachGoal('DAILY_BUDGET_LIMIT_MAIN_INVOICE_OFF');
                    counter.reachGoal('MAIN_INVOICE_DAILY_LIMIT_OFF', {
                        MAIN_INVOICE_DAILY_LIMIT_OFF: {
                            beforeLimit: initLimit
                        }
                    });
                } else if (initValue.isActive && newValue.isActive && initLimit < newLimit) {
                    counter.reachGoal('DAILY_BUDGET_LIMIT_MAIN_INVOICE_INCREASE');
                    counter.reachGoal('MAIN_INVOICE_DAILY_LIMIT_UP', {
                        MAIN_INVOICE_DAILY_LIMIT_UP: {
                            difference: newLimit - initLimit
                        }
                    });
                } else if (initValue.isActive && newValue.isActive && initLimit > newLimit) {
                    counter.reachGoal('DAILY_BUDGET_LIMIT_MAIN_INVOICE_DECREASE');
                }
            });
    },

    /**
    * Обработчик события клика на кнопку сохранения
    */
    _onCancelButtonClicked: function() {
        this.trigger('cancel');
    }
});
