block('b-wallet-day-budget')(

    js()(function() {
        return {
            recommendedSum: (this.ctx.dayBudget || {}).recommended_sum,
            cid: this.ctx.cid,
            modelParams: this.ctx.modelParams,
            commonWalletDayBudget: this.ctx.commonWalletDayBudget || {}
        };
    }),

    content()(function() {
        var dayBudget = this.ctx.dayBudget || {},
            budgetValueText = dayBudget.sum ?
                (+dayBudget.sum).toFixed(2) :
                iget2('b-wallet-day-budget', 'ne-zadan', 'не задан');

        return [
            iget2('b-wallet-day-budget', 'dnevnoy', 'Дневной'),
            ':&nbsp;',
            this.ctx.action && this.ctx.action.editCamp ?
                {
                    block: 'button',
                    mix: [{
                        block: 'b-wallet-day-budget',
                        elem: 'sum'
                    }],
                    mods: {
                        size: 's',
                        pseudo: 'yes',
                        theme: 'normal'
                    },
                    content: budgetValueText
                } :
                {
                    block: 'b-wallet-day-budget',
                    elem: 'sum',
                    content: budgetValueText
                }
        ];
    }),

    content().match(function() {
        return this.ctx.weekBudgetRestriction;
    })(function() {
        var autoBudgetSumText = this.ctx.autobudgetSum ?
            (+this.ctx.autobudgetSum).toFixed(2) :
            iget2('b-wallet-day-budget', 'ne-zadan', 'не задан');

        return this.ctx.isWeekBundle ?
            '—' :
            [iget2('b-wallet-day-budget', 'nedelnyy', 'Недельный'), ':&nbsp;', autoBudgetSumText]
    }),

    content().match(function() {
        return this.ctx.isPeriodBudget;
    })(function() {
        return iget2('b-wallet-day-budget', 'text-price-for-the-selected-period', 'На период:&nbsp;{autobudgetSum}', {
            autobudgetSum: (+this.ctx.autobudgetSum).toFixed(2),
            context: 'На период: 32.000 с 23.01.2018 по 24.01.2018'
        });
    })
);
