/**
 * @fires b-wallet-day-budget#save-click запрос на сохранение дневного бюджета
 */
BEM.DOM.decl('b-wallet-day-budget', {
    onSetMod: {
        js: function() {
            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._btn = this.findBlockOn('sum', 'button');
            this._btn && this._subscriptionManager.on(this._btn, 'click', this._openPopup, this);

            this._campaignModel = BEM.MODEL.getOne(this.params.modelParams);
            this._subscriptionManager.on(this._campaignModel.get('day_budget2'), 'change', this._onBudgetChanged, this);
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события изменения данных дневного бюджета
     */
    _onBudgetChanged: function() {
        var dayBudget = this._campaignModel.get('day_budget2'),
            isActive = dayBudget.get('set');

        this.setMod('warning', isActive && dayBudget.get('sum') < this.params.recommendedSum ? 'yes' : '');
        this._btn.elem('text').text(isActive ? dayBudget.get('sum', 'format') : iget2('b-wallet-day-budget', 'ne-zadan', 'не задан'));
    },

    /**
     * Возвращает экземпляр попапа
     * @returns {BEM}
     */
    _getPopup: function() {
        if (!this._popup) {
            this._popup = BEM.blocks['b-shared-popup'].getInstance(
                { autoclosable: 'yes', 'has-close': 'yes', common: 'yes' },
                { directions: ['left'] }
            );
        }

        return this._popup;
    },

    /**
     * Открывает и инициализирует попап редактирования дневного бюджета
     */
    _openPopup: function() {
        var dayBudget = this._campaignModel.get('day_budget2'),
            popup = this._getPopup(),
            walletPopup,
            commonWalletDayBudgetSum = +this.params.commonWalletDayBudget.sum,
            currency = this._campaignModel.get('currency');

        popup
            .setContent(BEMHTML.apply({
                block: 'b-wallet-day-budget-popup',
                mods: {
                    for: 'campaign'
                },
                note: commonWalletDayBudgetSum ?
                    iget2(
                        'b-wallet-day-budget',
                        'dlya-obshchego-scheta-zadan',
                        'Для общего счёта задан режим показов "{showMode}" и установлено ограничение дневного бюджета {sum} Укажите меньшее значение, чтобы ограничить дневной бюджет кампании.',
                        {
                            showMode: u['text-store']
                                .get('dayBudget', 'mode', this.params.commonWalletDayBudget.show_mode),

                            sum: u.currencies.formatSum(currency, commonWalletDayBudgetSum),
                            context: 'showMode - Распределённый; sum - 2 000 руб.'
                        }
                    ) :
                    '',
                helpLink: u.getHelpUrl('day-budget'),
                cid: this._campaignModel.get('cid'),
                value: dayBudget.get('sum'),
                mode: dayBudget.get('show_mode'),
                isActive: dayBudget.get('set'),
                currency: currency
            }))
            .show(this._btn);

        walletPopup = popup.findBlockInside('b-wallet-day-budget-popup');

        walletPopup.on('save', function(event, data) {
            this._campaignModel.get('day_budget2').update({
                set: data.isActive,
                sum: data.value,
                show_mode: data.mode
            });

            popup.hide();
        }, this);

        walletPopup.on('save-click', function() {
            this.trigger('save-click');
        }, this);

        walletPopup.on('cancel', function() {
            popup.hide();
        });

        popup.on('close', function() {
            walletPopup.un('cancel');
            walletPopup.un('save-click');
            walletPopup.un('save');
        });
    }
});
