block('b-wallet-info').content()(function() {
    var autopayMode = (this.data.autopay_settings || {}).autopay_mode,
        wallet = this.ctx.wallet,
        walletSum = wallet.total;

    return {
        elem: 'table',
        content: {
            elem: 'tr',
            content: [
                {
                    elem: 'td',
                    mix: [{
                        block: 'b-wallet-info',
                        elem: 'td-left'
                    }],
                    content: [
                        {
                            block: 'b-wallet-rest',
                            mix: [{
                                block: 'b-wallet-info',
                                elem: 'rest'
                            }],
                            wallet: wallet
                        }
                    ]
                },
                {
                    elem: 'td',
                    mix: [{
                        block: 'b-wallet-info',
                        elem: 'td-center'
                    }],
                    content: [
                        {
                            block: 'b-wallet-info',
                            elem: 'icon-text',
                            content: {
                                block: 'icon-text',
                                mods: {
                                    theme: 'info',
                                    size: 'ms'
                                },
                                text: wallet.enabled ?
                                    iget2('b-wallet-info', 'schyot-podklyuchen', 'Счёт подключён') :
                                    iget2('b-wallet-info', 'schyot-otklyuchen', 'Счёт отключён')
                            }
                        },
                        !this.data.is_wallet_locked && (!!wallet.enabled || walletSum > 0) &&
                            autopayMode !== 'min_balance' && {
                                elem: 'info-text',
                                content: iget2(
                                    'b-wallet-info',
                                    'balans-scheta',
                                    'Баланс счёта {balans}',
                                    { balans: u.currencies.formatSum(wallet.currency, walletSum) }
                                )
                            }
                    ]
                },
                {
                    elem: 'td',
                    mix: [{
                        block: 'b-wallet-info',
                        elem: 'td-right'
                    }],
                    content: {
                        block: 'link',
                        mix: [{
                            block: 'b-enable-wallet',
                            elem: 'link'
                        }],
                        content: iget2('b-wallet-info', 'platezhi-i-dokumenty', 'Платежи и документы'),
                        url: u.consts('balance-url')
                    }
                }
            ]
        }
    };
});
