block('b-wallet-link').elem('hint')(

    replace()(function() {
        var ctx = this.ctx,
            wallet = ctx.wallet,
            negativeWalletSumHintText =
                iget2('b-wallet-link', 'obratites-v-sluzhbu-podderzhki', 'Обратитесь в службу поддержки'),
            content;

        if (wallet.enabled) {
            content = [
                !!wallet.total && wallet.currency !== 'YND_FIXED' && {
                    block: 'b-wallet-link',
                    elem: 'hint-item',
                    content: wallet.total !== wallet.total_with_nds ?
                        [
                            {
                                elem: 'hint-item-name',
                                content: iget2('b-wallet-link', 'summa-s-nds', 'Сумма с НДС')
                            },
                            {
                                elem: 'hint-item-value',
                                content: u.currencies.formatSum(ctx.currency, wallet.total_with_nds)
                            }
                        ] :
                        iget2('b-wallet-link', 'nds-ne-primenyaetsya', 'НДС не применяется')
                },
                {
                    block: 'b-wallet-link',
                    elem: 'hint-item',
                    content: [
                        {
                            elem: 'hint-item-name',
                            content: iget2('b-wallet-link', 'nomer-scheta', 'Номер счёта')
                        },
                        {
                            elem: 'hint-item-value',
                            content: ctx.isWalletIdLinkDisabled ?
                                wallet.wallet_cid :
                                {
                                    block: 'link',
                                    url: u.formatUrl({
                                        protocol: 'https',
                                        host: u.consts('balance'),
                                        path: 'invoices.xml',
                                        query: {
                                            service_cc: 'PPC',
                                            ref_service_id: 7
                                        }
                                    }),
                                    content: wallet.wallet_cid
                                }
                        }
                    ]
                },
                {
                    block: 'b-help-link',
                    mods: { type: 'modal', decoration: 'no' },
                    mix: {
                        block: 'b-wallet-link',
                        elem: 'hint-link'
                    },
                    stretched: true,
                    url: u.getHelpUrl('shared-account'),
                    text: iget2('b-wallet-link', 'podrobnee-ob-obshchem-schete', 'Подробнее об общем счёте')
                }
            ];
        } else if (wallet.money_type != 'real' && wallet.total > 0) {
            content = [
                {
                    block: 'b-wallet-link',
                    elem: 'hint-item',
                    content: iget2(
                        'b-wallet-link',
                        'na-otklyuchennom-obshchem-schete2',
                        'На отключённом общем счёте остались неизрасходованные средства. При включении общего счёта деньги будут автоматически восстановлены на нём.'
                    )
                },
                {
                    block: 'link',
                    mix: {
                        block: 'b-wallet-link',
                        elem: 'hint-link'
                    },
                    url: ctx.linkToClientWallet,
                    text: iget2('b-wallet-link', 'podkyuchit', 'Подключить')
                }
            ];
        } else if (wallet.total < 0 || wallet.money_type != 'real' && wallet.total > 0) {
            content = !ctx.agencyContacts && !u.consts('domains').tr ?
                [
                    {
                        elem: 'hint-title',
                        content: negativeWalletSumHintText
                    },
                    {
                        block: 'b-office-contacts',
                        mods: {
                            type: 'common'
                        }
                    }
                ] :
                negativeWalletSumHintText;
        }

        if (!content) {
            return '';
        }

        return {
            block: 'dropdown',
            mix: {
                block: 'b-wallet-link',
                elem: 'hint'
            },
            content: [
                {
                    block: 'icon',
                    mods: {
                        'size-13': 'info',
                        theme: 'light'
                    },
                    mix: [
                        {
                            block: 'dropdown',
                            elem: 'switcher'
                        },
                        {
                            block: 'b-wallet-link',
                            elem: 'hint-icon'
                        }
                    ]
                },
                {
                    elem: 'popup',
                    js: { directions: ['right'] },
                    content: {
                        block: 'b-wallet-link',
                        elem: 'hint-popup',
                        content: content
                    }
                }
            ]
        }
    })
);
